/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.i18n.impl;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.pentaho.osgi.i18n.impl.LocalizationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationBundleListener
implements BundleListener {
    private static Logger log = LoggerFactory.getLogger(LocalizationBundleListener.class);
    private LocalizationManager localizationManager;
    private BundleContext bundleContext;

    public void setLocalizationManager(LocalizationManager localizationManager) {
        this.localizationManager = localizationManager;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    static void setLog(Logger log) {
        LocalizationBundleListener.log = log;
    }

    static Logger getLog() {
        return log;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                try {
                    this.localizationManager.bundleChanged(event.getBundle());
                    break;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void init() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.bundleChanged(new BundleEvent(2, bundle));
        }
    }
}

