/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E10_PRODUCT_SERVICE_LINE_INFO;
import ca.uhn.hl7v2.model.v26.segment.PSG;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EHC_E10_PRODUCT_SERVICE_GROUP
extends AbstractGroup {
    public EHC_E10_PRODUCT_SERVICE_GROUP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSG.class, true, false);
            this.add(EHC_E10_PRODUCT_SERVICE_LINE_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating EHC_E10_PRODUCT_SERVICE_GROUP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PSG getPSG() {
        PSG ret = null;
        try {
            ret = (PSG)this.get("PSG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E10_PRODUCT_SERVICE_LINE_INFO getPRODUCT_SERVICE_LINE_INFO() {
        EHC_E10_PRODUCT_SERVICE_LINE_INFO ret = null;
        try {
            ret = (EHC_E10_PRODUCT_SERVICE_LINE_INFO)this.get("PRODUCT_SERVICE_LINE_INFO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E10_PRODUCT_SERVICE_LINE_INFO getPRODUCT_SERVICE_LINE_INFO(int rep) {
        EHC_E10_PRODUCT_SERVICE_LINE_INFO ret = null;
        try {
            ret = (EHC_E10_PRODUCT_SERVICE_LINE_INFO)this.get("PRODUCT_SERVICE_LINE_INFO", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRODUCT_SERVICE_LINE_INFOReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRODUCT_SERVICE_LINE_INFO").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRODUCT_SERVICE_LINE_INFO(EHC_E10_PRODUCT_SERVICE_LINE_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT_SERVICE_LINE_INFO", (Structure)structure, rep);
    }

    public EHC_E10_PRODUCT_SERVICE_LINE_INFO insertPRODUCT_SERVICE_LINE_INFO(int rep) throws HL7Exception {
        return (EHC_E10_PRODUCT_SERVICE_LINE_INFO)super.insertRepetition("PRODUCT_SERVICE_LINE_INFO", rep);
    }

    public EHC_E10_PRODUCT_SERVICE_LINE_INFO removePRODUCT_SERVICE_LINE_INFO(int rep) throws HL7Exception {
        return (EHC_E10_PRODUCT_SERVICE_LINE_INFO)super.removeRepetition("PRODUCT_SERVICE_LINE_INFO", rep);
    }
}

