/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.segment.ADJ;
import ca.uhn.hl7v2.model.v26.segment.PSL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EHC_E15_PSL_ITEM_INFO
extends AbstractGroup {
    public EHC_E15_PSL_ITEM_INFO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSL.class, true, false);
            this.add(ADJ.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating EHC_E15_PSL_ITEM_INFO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PSL getPSL() {
        PSL ret = null;
        try {
            ret = (PSL)this.get("PSL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADJ getADJ() {
        ADJ ret = null;
        try {
            ret = (ADJ)this.get("ADJ");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADJ getADJ(int rep) {
        ADJ ret = null;
        try {
            ret = (ADJ)this.get("ADJ", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getADJReps() {
        int reps = -1;
        try {
            reps = this.getAll("ADJ").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertADJ(ADJ structure, int rep) throws HL7Exception {
        super.insertRepetition("ADJ", (Structure)structure, rep);
    }

    public ADJ insertADJ(int rep) throws HL7Exception {
        return (ADJ)super.insertRepetition("ADJ", rep);
    }

    public ADJ removeADJ(int rep) throws HL7Exception {
        return (ADJ)super.removeRepetition("ADJ", rep);
    }
}

