/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.EmptyNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class SimpleRegionNormalizer
implements RegionNormalizer {
    private static final Log LOG = LogFactory.getLog(SimpleRegionNormalizer.class);
    private MasterServices masterServices;

    @Override
    public void setMasterServices(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    @Override
    public NormalizationPlan computePlanForTable(TableName table) throws HBaseIOException {
        if (table == null || table.isSystemTable()) {
            LOG.debug((Object)("Normalization of table " + table + " isn't allowed"));
            return EmptyNormalizationPlan.getInstance();
        }
        List<HRegionInfo> tableRegions = this.masterServices.getAssignmentManager().getRegionStates().getRegionsOfTable(table);
        if (tableRegions == null || tableRegions.size() < 3) {
            LOG.debug((Object)("Table " + table + " has " + tableRegions.size() + " regions, required min number" + " of regions for normalizer to run is 3, not running normalizer"));
            return EmptyNormalizationPlan.getInstance();
        }
        LOG.debug((Object)("Computing normalization plan for table: " + table + ", number of regions: " + tableRegions.size()));
        long totalSizeMb = 0L;
        Pair largestRegion = new Pair();
        Pair smallestRegion = new Pair();
        int smallestRegionIndex = 0;
        for (int i = 0; i < tableRegions.size(); ++i) {
            HRegionInfo hri = tableRegions.get(i);
            long regionSize = this.getRegionSize(hri);
            totalSizeMb += regionSize;
            if (largestRegion.getFirst() == null || regionSize > (Long)largestRegion.getSecond()) {
                largestRegion.setFirst((Object)hri);
                largestRegion.setSecond((Object)regionSize);
            }
            if (smallestRegion.getFirst() != null && regionSize >= (Long)smallestRegion.getSecond()) continue;
            smallestRegion.setFirst((Object)hri);
            smallestRegion.setSecond((Object)regionSize);
            smallestRegionIndex = i;
        }
        long leftNeighborSize = -1L;
        long rightNeighborSize = -1L;
        if (smallestRegionIndex > 0) {
            leftNeighborSize = this.getRegionSize(tableRegions.get(smallestRegionIndex - 1));
        }
        if (smallestRegionIndex < tableRegions.size() - 1) {
            rightNeighborSize = this.getRegionSize(tableRegions.get(smallestRegionIndex + 1));
        }
        Pair smallestNeighborOfSmallestRegion = leftNeighborSize == -1L ? new Pair((Object)tableRegions.get(smallestRegionIndex + 1), (Object)rightNeighborSize) : (rightNeighborSize == -1L ? new Pair((Object)tableRegions.get(smallestRegionIndex - 1), (Object)leftNeighborSize) : (leftNeighborSize < rightNeighborSize ? new Pair((Object)tableRegions.get(smallestRegionIndex - 1), (Object)leftNeighborSize) : new Pair((Object)tableRegions.get(smallestRegionIndex + 1), (Object)rightNeighborSize)));
        double avgRegionSize = (double)totalSizeMb / (double)tableRegions.size();
        LOG.debug((Object)("Table " + table + ", total aggregated regions size: " + totalSizeMb));
        LOG.debug((Object)("Table " + table + ", average region size: " + avgRegionSize));
        if ((double)((Long)largestRegion.getSecond()).longValue() > 2.0 * avgRegionSize) {
            LOG.debug((Object)("Table " + table + ", largest region " + ((HRegionInfo)largestRegion.getFirst()).getRegionName() + " has size " + largestRegion.getSecond() + ", more than 2 times than avg size, splitting"));
            return new SplitNormalizationPlan((HRegionInfo)largestRegion.getFirst(), null);
        }
        if ((double)((Long)smallestRegion.getSecond() + (Long)smallestNeighborOfSmallestRegion.getSecond()) < avgRegionSize) {
            LOG.debug((Object)("Table " + table + ", smallest region size: " + smallestRegion.getSecond() + " and its smallest neighbor size: " + smallestNeighborOfSmallestRegion.getSecond() + ", less than half the avg size, merging them"));
            return new MergeNormalizationPlan((HRegionInfo)smallestRegion.getFirst(), (HRegionInfo)smallestNeighborOfSmallestRegion.getFirst());
        }
        LOG.debug((Object)("No normalization needed, regions look good for table: " + table));
        return EmptyNormalizationPlan.getInstance();
    }

    private long getRegionSize(HRegionInfo hri) {
        ServerName sn = this.masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
        RegionLoad regionLoad = (RegionLoad)this.masterServices.getServerManager().getLoad(sn).getRegionsLoad().get(hri.getRegionName());
        return regionLoad.getStorefileSizeMB();
    }
}

