/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.meta;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.HelpOption;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.util.IndentFormatter;
import org.apache.karaf.shell.util.ShellUtil;
import org.fusesource.jansi.Ansi;

public class ActionMetaData {
    private final Class<? extends Action> actionClass;
    private final Command command;
    private final Map<Option, Field> options;
    private final Map<Argument, Field> arguments;
    List<Argument> orderedArguments;
    private final Completer[] completers;

    public ActionMetaData(Class<? extends Action> actionClass, Command command, Map<Option, Field> options, Map<Argument, Field> args, List<Argument> orderedArguments, Completer[] completers) {
        this.actionClass = actionClass;
        this.command = command;
        this.options = options;
        this.arguments = args;
        this.orderedArguments = orderedArguments;
        this.completers = completers;
    }

    public Class<? extends Action> getActionClass() {
        return this.actionClass;
    }

    public Command getCommand() {
        return this.command;
    }

    public Map<Option, Field> getOptions() {
        return this.options;
    }

    public Map<Argument, Field> getArguments() {
        return this.arguments;
    }

    public Completer[] getCompleters() {
        return this.completers;
    }

    public List<Argument> getOrderedArguments() {
        return this.orderedArguments;
    }

    public void printUsage(Action action, PrintStream out, boolean globalScope, int termWidth) {
        if (this.command != null) {
            ArrayList<Argument> argumentsSet = new ArrayList<Argument>(this.arguments.keySet());
            Collections.sort(argumentsSet, new Comparator<Argument>(){

                @Override
                public int compare(Argument o1, Argument o2) {
                    return Integer.valueOf(o1.index()).compareTo(o2.index());
                }
            });
            HashSet<Option> optionsSet = new HashSet<Option>(this.options.keySet());
            optionsSet.add(HelpOption.HELP);
            if (this.command != null && (this.command.description() != null || this.command.name() != null)) {
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("DESCRIPTION").a(Ansi.Attribute.RESET));
                out.print("        ");
                if (this.command.name() != null) {
                    if (globalScope) {
                        out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(this.command.name()).a(Ansi.Attribute.RESET));
                    } else {
                        out.println(Ansi.ansi().a(this.command.scope()).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(this.command.name()).a(Ansi.Attribute.RESET));
                    }
                    out.println();
                }
                out.print("\t");
                out.println(this.command.description());
                out.println();
            }
            StringBuffer syntax = new StringBuffer();
            if (this.command != null) {
                if (globalScope) {
                    syntax.append(this.command.name());
                } else {
                    syntax.append(String.format("%s:%s", this.command.scope(), this.command.name()));
                }
            }
            if (this.options.size() > 0) {
                syntax.append(" [options]");
            }
            if (this.arguments.size() > 0) {
                syntax.append(' ');
                for (Argument argument : argumentsSet) {
                    if (!argument.required()) {
                        syntax.append(String.format("[%s] ", argument.name()));
                        continue;
                    }
                    syntax.append(String.format("%s ", argument.name()));
                }
            }
            out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("SYNTAX").a(Ansi.Attribute.RESET));
            out.print("        ");
            out.println(syntax.toString());
            out.println();
            if (this.arguments.size() > 0) {
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("ARGUMENTS").a(Ansi.Attribute.RESET));
                for (Argument argument : argumentsSet) {
                    out.print("        ");
                    out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(argument.name()).a(Ansi.Attribute.RESET));
                    IndentFormatter.printFormatted("                ", argument.description(), termWidth, out);
                    if (argument.required() || argument.valueToShowInHelp() == null || argument.valueToShowInHelp().length() == 0) continue;
                    if ("DEFAULT".equals(argument.valueToShowInHelp())) {
                        Object o = this.getDefaultValue(action, argument);
                        String string = this.getDefaultValueString(o);
                        if (string == null) continue;
                        this.printDefaultsTo(out, string);
                        continue;
                    }
                    this.printDefaultsTo(out, argument.valueToShowInHelp());
                }
                out.println();
            }
            if (this.options.size() > 0) {
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("OPTIONS").a(Ansi.Attribute.RESET));
                for (Option option : optionsSet) {
                    String opt = option.name();
                    for (String alias : option.aliases()) {
                        opt = opt + ", " + alias;
                    }
                    out.print("        ");
                    out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(opt).a(Ansi.Attribute.RESET));
                    IndentFormatter.printFormatted("                ", option.description(), termWidth, out);
                    if (option.valueToShowInHelp() == null || option.valueToShowInHelp().length() == 0) continue;
                    if ("DEFAULT".equals(option.valueToShowInHelp())) {
                        Object object = this.getDefaultValue(action, option);
                        String defaultValue = this.getDefaultValueString(object);
                        if (defaultValue == null) continue;
                        this.printDefaultsTo(out, defaultValue);
                        continue;
                    }
                    this.printDefaultsTo(out, option.valueToShowInHelp());
                }
                out.println();
            }
            if (this.command.detailedDescription().length() > 0) {
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("DETAILS").a(Ansi.Attribute.RESET));
                String desc = this.getDetailedDescription();
                IndentFormatter.printFormatted("        ", desc, termWidth, out);
            }
        }
    }

    public Object getDefaultValue(Action action, Argument argument) {
        try {
            this.arguments.get(argument).setAccessible(true);
            return this.arguments.get(argument).get(action);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getDefaultValue(Action action, Option option) {
        try {
            this.options.get(option).setAccessible(true);
            return this.options.get(option).get(action);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDetailedDescription() {
        String desc = this.command.detailedDescription();
        return this.loadDescription(this.actionClass, desc);
    }

    private String loadDescription(Class<?> clazz, String desc) {
        if (desc != null && desc.startsWith("classpath:")) {
            desc = ShellUtil.loadClassPathResource(clazz, desc.substring("classpath:".length()));
        }
        return desc;
    }

    public String getDefaultValueString(Object o) {
        if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
            return o.toString();
        }
        return null;
    }

    private void printDefaultsTo(PrintStream out, String value) {
        out.println("                (defaults to " + value + ")");
    }
}

