/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.pur.model.EERepositoryObject;
import org.pentaho.di.repository.pur.model.ObjectAcl;
import org.pentaho.di.repository.pur.model.RepositoryLock;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IAclObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.ILockObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IRevisionObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcls;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectRevision;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectRevisions;
import org.pentaho.di.ui.repository.pur.services.IAclService;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.repository.pur.services.IRevisionService;
import org.pentaho.di.ui.repository.repositoryexplorer.AccessDeniedException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIJob;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;

public class UIEEJob
extends UIJob
implements ILockObject,
IRevisionObject,
IAclObject,
Serializable {
    private static final long serialVersionUID = 1137552553918382891L;
    private ILockService lockService;
    private IRevisionService revisionService;
    private IAclService aclService;
    private UIRepositoryObjectRevisions revisions;
    private EERepositoryObject repObj;
    private ObjectAcl acl;
    private Map<RepositoryFilePermission, Boolean> hasAccess = null;

    public UIEEJob(RepositoryElementMetaInterface rc, UIRepositoryDirectory parent, Repository rep) {
        super(rc, parent, rep);
        if (!(rc instanceof EERepositoryObject)) {
            throw new IllegalArgumentException();
        }
        this.repObj = (EERepositoryObject)rc;
        try {
            if (!rep.hasService(ILockService.class)) {
                throw new IllegalStateException();
            }
            this.lockService = (ILockService)rep.getService(ILockService.class);
            if (!rep.hasService(IRevisionService.class)) {
                throw new IllegalStateException();
            }
            this.revisionService = (IRevisionService)rep.getService(IRevisionService.class);
            if (!rep.hasService(IAclService.class)) {
                throw new IllegalStateException();
            }
            this.aclService = (IAclService)rep.getService(IAclService.class);
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    public String getImage() {
        if (this.isLocked()) {
            return "ui/images/lock.svg";
        }
        return "ui/images/jobrepo.svg";
    }

    @Override
    public String getLockMessage() throws KettleException {
        return this.repObj.getLockMessage();
    }

    @Override
    public void lock(String lockNote) throws KettleException {
        RepositoryLock lock = this.lockService.lockJob(this.getObjectId(), lockNote);
        this.repObj.setLock(lock);
        this.uiParent.fireCollectionChanged();
    }

    @Override
    public void unlock() throws KettleException {
        this.lockService.unlockJob(this.getObjectId());
        this.repObj.setLock(null);
        this.uiParent.fireCollectionChanged();
    }

    @Override
    public boolean isLocked() {
        return this.getRepositoryLock() != null;
    }

    @Override
    public RepositoryLock getRepositoryLock() {
        return this.repObj.getLock();
    }

    @Override
    public UIRepositoryObjectRevisions getRevisions() throws KettleException {
        if (this.revisions != null) {
            return this.revisions;
        }
        this.revisions = new UIRepositoryObjectRevisions();
        List<ObjectRevision> or = this.revisionService.getRevisions(this.getObjectId());
        for (ObjectRevision rev : or) {
            this.revisions.add(new UIRepositoryObjectRevision(rev));
        }
        return this.revisions;
    }

    protected void refreshRevisions() throws KettleException {
        this.revisions = null;
        this.getRevisions();
    }

    @Override
    public void restoreRevision(UIRepositoryObjectRevision revision, String commitMessage) throws KettleException {
        if (this.revisionService != null) {
            this.revisionService.restoreJob(this.getObjectId(), revision.getName(), commitMessage);
            this.refreshRevisions();
            this.uiParent.fireCollectionChanged();
        }
    }

    @Override
    public void getAcls(UIRepositoryObjectAcls acls, boolean forceParentInheriting) throws AccessDeniedException {
        if (this.acl == null) {
            try {
                this.acl = this.aclService.getAcl(this.getObjectId(), forceParentInheriting);
            }
            catch (KettleException ke) {
                throw new AccessDeniedException((Throwable)ke);
            }
        }
        acls.setObjectAcl(this.acl);
    }

    @Override
    public void getAcls(UIRepositoryObjectAcls acls) throws AccessDeniedException {
        this.getAcls(acls, false);
    }

    @Override
    public void setAcls(UIRepositoryObjectAcls security) throws AccessDeniedException {
        try {
            this.aclService.setAcl(this.getObjectId(), security.getObjectAcl());
        }
        catch (KettleException e) {
            throw new AccessDeniedException((Throwable)e);
        }
    }

    @Override
    public void clearAcl() {
        this.acl = null;
        this.hasAccess = null;
    }

    @Override
    public boolean hasAccess(RepositoryFilePermission perm) throws KettleException {
        if (this.hasAccess == null) {
            this.hasAccess = new HashMap<RepositoryFilePermission, Boolean>();
        }
        if (this.hasAccess.get(perm) == null) {
            this.hasAccess.put(perm, new Boolean(this.aclService.hasAccess(this.repObj.getObjectId(), perm)));
        }
        return this.hasAccess.get(perm);
    }

    protected ObjectId renameJob(ObjectId objectId, RepositoryDirectory directory, String name) throws Exception {
        ObjectId id = super.renameJob(objectId, directory, name);
        this.refreshRevisions();
        return id;
    }

    @Override
    public Boolean getVersioningEnabled() {
        return this.repObj.getVersioningEnabled();
    }

    @Override
    public Boolean getVersionCommentEnabled() {
        return this.repObj.getVersionCommentEnabled();
    }
}

