/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.data.BinInterSedes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerWritable
implements WritableComparable<BigIntegerWritable> {
    private static final BinInterSedes bis = new BinInterSedes();
    private BigInteger value;

    public BigIntegerWritable() {
        this.value = BigInteger.ZERO;
    }

    public BigIntegerWritable(BigInteger bi) {
        this.value = bi;
    }

    public void set(BigInteger value) {
        this.value = value;
    }

    public BigInteger get() {
        return this.value;
    }

    public int compareTo(BigIntegerWritable o) {
        return this.value.compareTo(o.get());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BigIntegerWritable)) {
            return false;
        }
        return this.compareTo((BigIntegerWritable)o) == 0;
    }

    public String toString() {
        return this.value.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.value = (BigInteger)bis.readDatum(in);
    }

    public void write(DataOutput out) throws IOException {
        bis.writeDatum(out, this.value, (byte)65);
    }

    static {
        WritableComparator.define(BigIntegerWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        private BigIntegerWritable thisValue = new BigIntegerWritable();
        private BigIntegerWritable thatValue = new BigIntegerWritable();

        public Comparator() {
            super(BigIntegerWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                this.thisValue.readFields(new DataInputStream(new ByteArrayInputStream(b1, s1, l1)));
                this.thatValue.readFields(new DataInputStream(new ByteArrayInputStream(b2, s2, l2)));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read field from byte array: " + e);
            }
            return this.thisValue.compareTo(this.thatValue);
        }
    }
}

