/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.accumulo;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.pig.LoadStoreCaster;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.accumulo.FixedByteArrayOutputStream;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccumuloBinaryConverter
implements LoadStoreCaster {
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;

    @Override
    public DataBag bytesToBag(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        throw new ExecException("Can't generate DataBags from byte[]");
    }

    @Override
    public BigDecimal bytesToBigDecimal(byte[] b) throws IOException {
        throw new ExecException("Can't generate a BigInteger from byte[]");
    }

    @Override
    public BigInteger bytesToBigInteger(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        int len = dis.readInt();
        len ^= Integer.MIN_VALUE;
        len = Math.abs(len);
        byte[] bytes = new byte[len];
        dis.readFully(bytes);
        bytes[0] = (byte)(0x80 ^ bytes[0]);
        return new BigInteger(bytes);
    }

    @Override
    public Boolean bytesToBoolean(byte[] b) throws IOException {
        Preconditions.checkArgument((1 == b.length ? 1 : 0) != 0);
        return b[0] == 1;
    }

    @Override
    public String bytesToCharArray(byte[] b) throws IOException {
        return new String(b, Constants.UTF8);
    }

    @Override
    public DateTime bytesToDateTime(byte[] b) throws IOException {
        String s = new String(b, Constants.UTF8);
        return DateTime.parse((String)s);
    }

    @Override
    public Double bytesToDouble(byte[] b) throws IOException {
        return Double.longBitsToDouble(this.bytesToLong(b));
    }

    @Override
    public Float bytesToFloat(byte[] b) throws IOException {
        return Float.valueOf(Float.intBitsToFloat(this.bytesToInteger(b)));
    }

    @Override
    public Integer bytesToInteger(byte[] b) throws IOException {
        Preconditions.checkArgument((b.length == 4 ? 1 : 0) != 0);
        int n = 0;
        for (int i = 0; i < b.length; ++i) {
            n <<= 8;
            n ^= b[i] & 0xFF;
        }
        return n;
    }

    @Override
    public Long bytesToLong(byte[] b) throws IOException {
        Preconditions.checkArgument((b.length == 8 ? 1 : 0) != 0);
        long l = 0L;
        for (int i = 0; i < b.length; ++i) {
            l <<= 8;
            l ^= (long)(b[i] & 0xFF);
        }
        return l;
    }

    @Override
    public Map<String, Object> bytesToMap(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        throw new ExecException("Can't generate Map from byte[]");
    }

    @Override
    public Tuple bytesToTuple(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        throw new ExecException("Can't generate a Tuple from byte[]");
    }

    @Override
    public byte[] toBytes(BigDecimal bd) throws IOException {
        throw new IOException("Can't generate bytes from BigDecimal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes(BigInteger bi) throws IOException {
        byte[] bytes = bi.toByteArray();
        byte[] ret = new byte[4 + bytes.length];
        DataOutputStream dos = new DataOutputStream(new FixedByteArrayOutputStream(ret));
        bytes[0] = (byte)(0x80 ^ bytes[0]);
        int len = bytes.length;
        if (bi.signum() < 0) {
            len = -len;
        }
        len ^= Integer.MIN_VALUE;
        try {
            dos.writeInt(len);
            dos.write(bytes);
        }
        finally {
            dos.close();
        }
        return ret;
    }

    @Override
    public byte[] toBytes(Boolean b) throws IOException {
        return new byte[]{b != false ? (byte)1 : 0};
    }

    @Override
    public byte[] toBytes(DataBag bag) throws IOException {
        throw new ExecException("Cant' generate bytes from DataBag");
    }

    @Override
    public byte[] toBytes(DataByteArray a) throws IOException {
        return a.get();
    }

    @Override
    public byte[] toBytes(DateTime dt) throws IOException {
        return dt.toString().getBytes(Constants.UTF8);
    }

    @Override
    public byte[] toBytes(Double d) throws IOException {
        return this.toBytes(Double.doubleToRawLongBits(d));
    }

    @Override
    public byte[] toBytes(Float f) throws IOException {
        return this.toBytes(Float.floatToRawIntBits(f.floatValue()));
    }

    @Override
    public byte[] toBytes(Integer val) throws IOException {
        int intVal = val;
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)intVal;
            intVal >>>= 8;
        }
        b[0] = (byte)intVal;
        return b;
    }

    @Override
    public byte[] toBytes(Long val) throws IOException {
        long longVal = val;
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)longVal;
            longVal >>>= 8;
        }
        b[0] = (byte)longVal;
        return b;
    }

    @Override
    public byte[] toBytes(Map<String, Object> m) throws IOException {
        throw new IOException("Can't generate bytes from Map");
    }

    @Override
    public byte[] toBytes(String s) throws IOException {
        return s.getBytes(Constants.UTF8);
    }

    @Override
    public byte[] toBytes(Tuple t) throws IOException {
        throw new IOException("Can't generate bytes from Tuple");
    }
}

