/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.accumulo;

import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;

public class AccumuloStorageOptions {
    public static final Option CASTER_OPTION = new Option("c", "caster", true, "Implementation of LoadStoreCaster to use typically UTF8StringConverter or AccumuloBinaryConverter");
    public static final Option AUTHORIZATIONS_OPTION = new Option("auths", "authorizations", true, "Comma-separated list of authorizations to use");
    public static final Option START_ROW_OPTION = new Option("s", "start", true, "The row to begin reading from, inclusive");
    public static final Option END_ROW_OPTION = new Option("e", "end", true, "The row to read until, inclusive");
    public static final Option MUTATION_BUFFER_SIZE_OPTION = new Option("buff", "mutation-buffer-size", true, "Number of bytes to buffer when writing data");
    public static final Option WRITE_THREADS_OPTION = new Option("wt", "write-threads", true, "Number of threads to use when writing data");
    public static final Option MAX_LATENCY_OPTION = new Option("ml", "max-latency", true, "Maximum latency in milliseconds before Mutations are flushed to Accumulo");
    public static final Option COLUMN_SEPARATOR_OPTION = new Option("sep", "separator", true, "Separator string to use when parsing columns");
    public static final Option COLUMN_IGNORE_WHITESPACE_OPTION = new Option("iw", "ignore-whitespace", true, "Whether or not whitespace should be stripped from column list");
    private Options options;
    private GnuParser parser = new GnuParser();

    public AccumuloStorageOptions() {
        this.options = new Options();
        this.options.addOption(CASTER_OPTION);
        this.options.addOption(AUTHORIZATIONS_OPTION);
        this.options.addOption(START_ROW_OPTION);
        this.options.addOption(END_ROW_OPTION);
        this.options.addOption(MUTATION_BUFFER_SIZE_OPTION);
        this.options.addOption(WRITE_THREADS_OPTION);
        this.options.addOption(MAX_LATENCY_OPTION);
        this.options.addOption(COLUMN_SEPARATOR_OPTION);
        this.options.addOption(COLUMN_IGNORE_WHITESPACE_OPTION);
    }

    public String getHelpMessage() {
        return "[(-c|--caster) LoadStoreCasterImpl] [(-auths|--authorizations auth1,auth2,auth3] [(-s|--start) startrow] [(-e|--end) endrow] [(-buff|--mutation-buffer-size) bytes] [(-wt|--write-threads) threads] [(-ml|--max-latency) seconds] [(-sep|--separator) ,] [(-iw|--ignore-whitespace) true|false]";
    }

    public CommandLine getCommandLine(String args) throws ParseException {
        String[] splitArgs = StringUtils.split((String)args);
        try {
            return this.parser.parse(this.options, splitArgs);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(this.getHelpMessage(), this.options);
            throw e;
        }
    }

    public boolean hasAuthorizations(CommandLine cli) {
        return cli.hasOption(AUTHORIZATIONS_OPTION.getOpt());
    }

    public Authorizations getAuthorizations(CommandLine cli) {
        return new Authorizations(new String[]{cli.getOptionValue(AUTHORIZATIONS_OPTION.getOpt(), "")});
    }

    public long getLong(CommandLine cli, Option o) {
        String value = cli.getOptionValue(o.getOpt());
        return null == value ? null : Long.valueOf(Long.parseLong(value));
    }

    public int getInt(CommandLine cli, Option o) {
        String value = cli.getOptionValue(o.getOpt());
        return null == value ? null : Integer.valueOf(Integer.parseInt(value));
    }
}

