/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer;
import org.apache.hadoop.mapreduce.task.ReduceContextImpl;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.IllustrateDummyReporter;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigGenericMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.pen.FakeRawKeyValueIterator;

public class PigMapReduce
extends PigGenericMapReduce {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reduce
    extends PigGenericMapReduce.Reduce {
        @Override
        public Reducer.Context getIllustratorContext(org.apache.hadoop.mapred.jobcontrol.Job job, List<Pair<PigNullableWritable, Writable>> input, POPackage pkg) throws IOException, InterruptedException {
            IllustrateReducerContext.IllustratorContext reducerContext = new IllustrateReducerContext().getReducerContext((ReduceContext<PigNullableWritable, NullableTuple, PigNullableWritable, Writable>)new IllustratorContextImpl(job, input, pkg));
            return reducerContext;
        }

        @Override
        public boolean inIllustrator(Reducer.Context context) {
            return context instanceof IllustrateReducerContext.IllustratorContext;
        }

        @Override
        public POPackage getPack(Reducer.Context context) {
            return ((IllustrateReducerContext.IllustratorContext)context).getPack();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class IllustratorContextImpl
        extends ReduceContextImpl<PigNullableWritable, NullableTuple, PigNullableWritable, Writable> {
            private PigNullableWritable currentKey;
            private PigNullableWritable nextKey;
            private NullableTuple nextValue;
            private List<NullableTuple> currentValues;
            private Iterator<Pair<PigNullableWritable, Writable>> it;
            private final ByteArrayOutputStream bos;
            private final DataOutputStream dos;
            private final RawComparator sortComparator;
            private final RawComparator groupingComparator;
            public POPackage pack;
            private IllustratorValueIterable iterable;

            public IllustratorContextImpl(org.apache.hadoop.mapred.jobcontrol.Job job, List<Pair<PigNullableWritable, Writable>> input, POPackage pkg) throws IOException, InterruptedException {
                super((Configuration)job.getJobConf(), new TaskAttemptID(), (RawKeyValueIterator)new FakeRawKeyValueIterator(input.iterator().hasNext()), null, null, null, null, (StatusReporter)new IllustrateDummyReporter(), null, PigNullableWritable.class, NullableTuple.class);
                this.currentKey = null;
                this.nextKey = null;
                this.nextValue = null;
                this.currentValues = null;
                this.pack = null;
                this.iterable = new IllustratorValueIterable();
                this.bos = new ByteArrayOutputStream();
                this.dos = new DataOutputStream(this.bos);
                Job nwJob = new Job((Configuration)job.getJobConf());
                this.sortComparator = nwJob.getSortComparator();
                this.groupingComparator = nwJob.getGroupingComparator();
                Collections.sort(input, new Comparator<Pair<PigNullableWritable, Writable>>(){

                    @Override
                    public int compare(Pair<PigNullableWritable, Writable> o1, Pair<PigNullableWritable, Writable> o2) {
                        try {
                            ((PigNullableWritable)o1.first).write(IllustratorContextImpl.this.dos);
                            int l1 = IllustratorContextImpl.this.bos.size();
                            ((PigNullableWritable)o2.first).write(IllustratorContextImpl.this.dos);
                            int l2 = IllustratorContextImpl.this.bos.size();
                            byte[] bytes = IllustratorContextImpl.this.bos.toByteArray();
                            IllustratorContextImpl.this.bos.reset();
                            return IllustratorContextImpl.this.sortComparator.compare(bytes, 0, l1, bytes, l1, l2 - l1);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Serialization exception in sort:" + e.getMessage());
                        }
                    }
                });
                this.currentValues = new ArrayList<NullableTuple>();
                this.it = input.iterator();
                if (this.it.hasNext()) {
                    Pair<PigNullableWritable, Writable> entry = this.it.next();
                    this.nextKey = (PigNullableWritable)entry.first;
                    this.nextValue = (NullableTuple)entry.second;
                }
                this.pack = pkg;
            }

            public PigNullableWritable getCurrentKey() {
                return this.currentKey;
            }

            public boolean nextKey() {
                if (this.nextKey == null) {
                    return false;
                }
                this.currentKey = this.nextKey;
                this.currentValues.clear();
                this.currentValues.add(this.nextValue);
                this.nextKey = null;
                while (this.it.hasNext()) {
                    Pair<PigNullableWritable, Writable> entry = this.it.next();
                    if (this.groupingComparator.compare((Object)this.currentKey, entry.first) == 0) {
                        this.currentValues.add((NullableTuple)entry.second);
                        continue;
                    }
                    this.nextKey = (PigNullableWritable)entry.first;
                    this.nextValue = (NullableTuple)entry.second;
                    break;
                }
                return true;
            }

            public Iterable<NullableTuple> getValues() {
                return this.iterable;
            }

            public void write(PigNullableWritable k, Writable t) {
            }

            public void progress() {
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected class IllustratorValueIterable
            implements Iterable<NullableTuple> {
                private IllustratorValueIterator iterator;

                protected IllustratorValueIterable() {
                    this.iterator = new IllustratorValueIterator();
                }

                @Override
                public Iterator<NullableTuple> iterator() {
                    return this.iterator;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class IllustratorValueIterator
            implements ReduceContext.ValueIterator<NullableTuple> {
                private int pos = -1;
                private int mark = -1;

                public void mark() throws IOException {
                    this.mark = this.pos - 1;
                    if (this.mark < -1) {
                        this.mark = -1;
                    }
                }

                public void reset() throws IOException {
                    this.pos = this.mark;
                }

                public void clearMark() throws IOException {
                    this.mark = -1;
                }

                public boolean hasNext() {
                    return this.pos < IllustratorContextImpl.this.currentValues.size() - 1;
                }

                public NullableTuple next() {
                    ++this.pos;
                    return (NullableTuple)IllustratorContextImpl.this.currentValues.get(this.pos);
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove not implemented");
                }

                public void resetBackupStore() throws IOException {
                    this.pos = -1;
                    this.mark = -1;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IllustrateReducerContext
    extends WrappedReducer<PigNullableWritable, NullableTuple, PigNullableWritable, Writable> {
        IllustrateReducerContext() {
        }

        public IllustratorContext getReducerContext(ReduceContext<PigNullableWritable, NullableTuple, PigNullableWritable, Writable> reduceContext) {
            return new IllustratorContext(reduceContext);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class IllustratorContext
        extends WrappedReducer.Context {
            public IllustratorContext(ReduceContext<PigNullableWritable, NullableTuple, PigNullableWritable, Writable> reduceContext) {
                super((WrappedReducer)IllustrateReducerContext.this, reduceContext);
            }

            public POPackage getPack() {
                return ((Reduce.IllustratorContextImpl)this.reduceContext).pack;
            }
        }
    }
}

