/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.OverwritableStoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputCommitter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.ObjectSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigOutputFormat
extends OutputFormat<WritableComparable, Tuple> {
    public static final String PIG_MAPRED_OUTPUT_DIR = "pig.mapred.output.dir";
    public static final String PIG_TMP_PATH = "pig.tmp.path";
    protected List<POStore> reduceStores = null;
    protected List<POStore> mapStores = null;
    protected Configuration currentConf = null;

    public RecordWriter<WritableComparable, Tuple> getRecordWriter(TaskAttemptContext taskattemptcontext) throws IOException, InterruptedException {
        this.setupUdfEnvAndStores((JobContext)taskattemptcontext);
        if (this.mapStores.size() + this.reduceStores.size() == 1) {
            POStore store = this.mapStores.size() == 1 ? this.mapStores.get(0) : this.reduceStores.get(0);
            StoreFuncInterface sFunc = store.getStoreFunc();
            PigOutputFormat.setLocation((JobContext)taskattemptcontext, store);
            RecordWriter writer = sFunc.getOutputFormat().getRecordWriter(taskattemptcontext);
            return new PigRecordWriter(writer, sFunc, Mode.SINGLE_STORE);
        }
        return new PigRecordWriter(null, null, Mode.MULTI_STORE);
    }

    public static void setLocation(JobContext jobContext, POStore store) throws IOException {
        Job storeJob = new Job(jobContext.getConfiguration());
        StoreFuncInterface storeFunc = store.getStoreFunc();
        String outputLocation = store.getSFile().getFileName();
        storeFunc.setStoreLocation(outputLocation, storeJob);
        ConfigurationUtil.mergeConf(jobContext.getConfiguration(), storeJob.getConfiguration());
    }

    public void checkOutputSpecs(JobContext jobcontext) throws IOException, InterruptedException {
        this.setupUdfEnvAndStores(jobcontext);
        this.checkOutputSpecsHelper(this.mapStores, jobcontext);
        this.checkOutputSpecsHelper(this.reduceStores, jobcontext);
    }

    private void checkOutputSpecsHelper(List<POStore> stores, JobContext jobcontext) throws IOException, InterruptedException {
        for (POStore store : stores) {
            JobContext jobContextCopy = HadoopShims.createJobContext(jobcontext.getConfiguration(), jobcontext.getJobID());
            PigOutputFormat.setLocation(jobContextCopy, store);
            StoreFuncInterface sFunc = store.getStoreFunc();
            OutputFormat of = sFunc.getOutputFormat();
            try {
                of.checkOutputSpecs(jobContextCopy);
            }
            catch (IOException ioe) {
                boolean shouldThrowException = true;
                if (sFunc instanceof OverwritableStoreFunc && ((OverwritableStoreFunc)((Object)sFunc)).shouldOverwrite() && (ioe instanceof org.apache.hadoop.mapred.FileAlreadyExistsException || ioe instanceof FileAlreadyExistsException)) {
                    shouldThrowException = false;
                }
                if (!shouldThrowException) continue;
                throw ioe;
            }
        }
    }

    private List<POStore> getStores(Configuration conf, String storeLookupKey) throws IOException {
        return (List)ObjectSerializer.deserialize(conf.get(storeLookupKey));
    }

    protected void setupUdfEnvAndStores(JobContext jobcontext) throws IOException {
        Configuration newConf = jobcontext.getConfiguration();
        MapRedUtil.setupUDFContext(newConf);
        if (!this.isConfPropEqual("udf.import.list", this.currentConf, newConf)) {
            PigContext.setPackageImportList((ArrayList)ObjectSerializer.deserialize(newConf.get("udf.import.list")));
        }
        if (!this.isConfPropEqual("pig.map.stores", this.currentConf, newConf)) {
            this.mapStores = this.getStores(newConf, "pig.map.stores");
        }
        if (!this.isConfPropEqual("pig.reduce.stores", this.currentConf, newConf)) {
            this.reduceStores = this.getStores(newConf, "pig.reduce.stores");
        }
        this.currentConf = new Configuration(newConf);
    }

    private boolean isConfPropEqual(String prop, Configuration conf1, Configuration conf2) {
        if ((conf1 == null || conf2 == null) && conf1 != conf2) {
            return false;
        }
        String str1 = conf1.get(prop);
        String str2 = conf2.get(prop);
        if ((str1 == null || str2 == null) && str1 != str2) {
            return false;
        }
        return str1.equals(str2);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext taskattemptcontext) throws IOException, InterruptedException {
        this.setupUdfEnvAndStores((JobContext)taskattemptcontext);
        return new PigOutputCommitter(taskattemptcontext, this.mapStores, this.reduceStores);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PigRecordWriter
    extends RecordWriter<WritableComparable, Tuple> {
        private RecordWriter wrappedWriter;
        private StoreFuncInterface sFunc;
        private Mode mode;

        public PigRecordWriter(RecordWriter wrappedWriter, StoreFuncInterface sFunc, Mode mode) throws IOException {
            this.mode = mode;
            if (mode == Mode.SINGLE_STORE) {
                this.wrappedWriter = wrappedWriter;
                this.sFunc = sFunc;
                this.sFunc.prepareToWrite(this.wrappedWriter);
            }
        }

        public void write(WritableComparable key, Tuple value) throws IOException, InterruptedException {
            if (this.mode != Mode.SINGLE_STORE) {
                throw new IOException("Internal Error: Unexpected code path");
            }
            this.sFunc.putNext(value);
        }

        public void close(TaskAttemptContext taskattemptcontext) throws IOException, InterruptedException {
            if (this.mode == Mode.SINGLE_STORE) {
                this.wrappedWriter.close(taskattemptcontext);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        SINGLE_STORE,
        MULTI_STORE;

    }
}

