/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans;

import java.util.HashSet;
import java.util.Set;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdfCacheShipFilesVisitor
extends PhyPlanVisitor {
    private Set<String> cacheFiles = new HashSet<String>();
    private Set<String> shipFiles = new HashSet<String>();

    public UdfCacheShipFilesVisitor(PhysicalPlan plan) {
        super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
    }

    @Override
    public void visitLoad(POLoad ld) throws VisitorException {
        if (ld.getCacheFiles() != null) {
            this.cacheFiles.addAll(ld.getCacheFiles());
        }
        if (ld.getShipFiles() != null) {
            this.shipFiles.addAll(ld.getShipFiles());
        }
    }

    @Override
    public void visitStore(POStore st) throws VisitorException {
        if (st.getCacheFiles() != null) {
            this.cacheFiles.addAll(st.getCacheFiles());
        }
        if (st.getShipFiles() != null) {
            this.shipFiles.addAll(st.getShipFiles());
        }
    }

    @Override
    public void visitUserFunc(POUserFunc udf) throws VisitorException {
        if (udf.getCacheFiles() != null) {
            this.cacheFiles.addAll(udf.getCacheFiles());
        }
        if (udf.getShipFiles() != null) {
            this.shipFiles.addAll(udf.getShipFiles());
        }
    }

    @Override
    public void visitCast(POCast cast) {
        Object obj;
        if (cast.getFuncSpec() != null && (obj = PigContext.instantiateFuncFromSpec(cast.getFuncSpec())) instanceof LoadFunc) {
            LoadFunc loadFunc = (LoadFunc)obj;
            if (loadFunc.getCacheFiles() != null) {
                this.cacheFiles.addAll(loadFunc.getCacheFiles());
            }
            if (loadFunc.getShipFiles() != null) {
                this.shipFiles.addAll(loadFunc.getShipFiles());
            }
        }
    }

    public Set<String> getCacheFiles() {
        return this.cacheFiles;
    }

    public Set<String> getShipFiles() {
        return this.shipFiles;
    }
}

