/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.NullableUnknownWritable;
import org.apache.pig.impl.io.PigNullableWritable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiQueryPackager
extends Packager {
    private static final long serialVersionUID = 1L;
    private static int idxPart = 127;
    private List<Packager> packagers = new ArrayList<Packager>();
    private ArrayList<Boolean> isKeyWrapped = new ArrayList();
    private boolean sameMapKeyType = true;
    private boolean inCombiner = false;
    private PigNullableWritable keyWritable = null;

    public void addPackager(Packager pkgr) {
        this.packagers.add(pkgr);
    }

    public void addPackager(Packager pkgr, byte mapKeyType) {
        this.packagers.add(pkgr);
        this.isKeyWrapped.add(mapKeyType != 110);
    }

    public List<Packager> getPackagers() {
        return this.packagers;
    }

    @Override
    public Result getNext() throws ExecException {
        if (this.bags == null) {
            return new Result(3, null);
        }
        byte by = this.keyWritable.getIndex();
        int index = by;
        if ((index &= idxPart) >= this.packagers.size() || index < 0) {
            int errCode = 2140;
            String msg = "Invalid package index " + index + " should be in the range between 0 and " + this.packagers.size();
            throw new ExecException(msg, errCode, 4);
        }
        Packager pkgr = this.packagers.get(index);
        PigNullableWritable curKey = this.keyWritable;
        if (!this.sameMapKeyType && !this.inCombiner && this.isKeyWrapped.get(index).booleanValue()) {
            Tuple tup = (Tuple)this.keyWritable.getValueAsPigType();
            curKey = HDataType.getWritableComparableTypes(tup.get(0), pkgr.getKeyType());
            curKey.setIndex(by);
        }
        pkgr.attachInput(curKey, this.bags, this.readOnce);
        Result res = pkgr.getNext();
        pkgr.detachInput();
        this.detachInput();
        Tuple tuple = (Tuple)res.result;
        Object obj = tuple.get(0);
        if (obj instanceof PigNullableWritable) {
            ((PigNullableWritable)obj).setIndex(by);
        } else {
            PigNullableWritable myObj = null;
            if (obj == null) {
                myObj = new NullableUnknownWritable();
                myObj.setNull(true);
            } else {
                myObj = HDataType.getWritableComparableTypes(obj, HDataType.findTypeFromNullableWritable(curKey));
            }
            myObj.setIndex(by);
            tuple.set(0, myObj);
        }
        return res;
    }

    public List<Boolean> getIsKeyWrappedList() {
        return Collections.unmodifiableList(this.isKeyWrapped);
    }

    public void addIsKeyWrappedList(List<Boolean> lst) {
        for (Boolean b : lst) {
            this.isKeyWrapped.add(b);
        }
    }

    public void setInCombiner(boolean inCombiner) {
        this.inCombiner = inCombiner;
    }

    public boolean isInCombiner() {
        return this.inCombiner;
    }

    public void setSameMapKeyType(boolean sameMapKeyType) {
        this.sameMapKeyType = sameMapKeyType;
    }

    public boolean isSameMapKeyType() {
        return this.sameMapKeyType;
    }

    @Override
    public int getNumInputs(byte index) {
        return this.packagers.get(index & idxPart).getNumInputs(index);
    }

    @Override
    public Tuple getValueTuple(PigNullableWritable keyWritable, NullableTuple ntup, int origIndex) throws ExecException {
        this.keyWritable = keyWritable;
        int index = origIndex & idxPart;
        PigNullableWritable newKey = keyWritable;
        if (!this.sameMapKeyType && !this.inCombiner && this.isKeyWrapped.get(index).booleanValue()) {
            Tuple tup = (Tuple)this.keyWritable.getValueAsPigType();
            newKey = HDataType.getWritableComparableTypes(tup.get(0), this.packagers.get(index).getKeyType());
            newKey.setIndex((byte)origIndex);
        }
        return this.packagers.get(index).getValueTuple(newKey, ntup, origIndex);
    }
}

