/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POMergeCogroup
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    private transient List<LoadFunc> sideLoaders;
    private List<FuncSpec> sidFuncSpecs;
    private List<String> sideFileSpecs;
    private POLocalRearrange[] LRs;
    private transient boolean firstTime;
    private transient Comparable<Object> firstKeyOfNextSplit;
    private transient int relationCnt;
    private transient TupleFactory mTupleFactory;
    private String indexFileName;
    private FuncSpec idxFuncSpec;
    private transient DataBag[] outBags;
    private transient Tuple prevTopOfHeap;
    private List<String> loaderSignatures;
    private transient boolean createNewBags;
    private transient PriorityQueue<Tuple> heap;
    private transient boolean lastTime;
    private transient boolean workingOnNewKey;
    private byte endOfRecordMark = (byte)3;
    int counter = 0;

    public POMergeCogroup(OperatorKey k, List<PhysicalOperator> inpPOs, POLocalRearrange[] lrs, int parallel) {
        super(k, parallel, inpPOs);
        this.LRs = lrs;
        for (int i = 0; i < lrs.length; ++i) {
            this.LRs[i].setStripKeyFromValue(false);
        }
    }

    public void setEndOfRecordMark(byte endOfRecordMark) {
        this.endOfRecordMark = endOfRecordMark;
    }

    @Override
    public Result getNextTuple() throws ExecException {
        try {
            Tuple topOfHeap;
            Tuple rearranged;
            if (this.createNewBags) {
                for (int i = 0; i < this.relationCnt; ++i) {
                    this.outBags[i] = new InternalCachedBag(this.relationCnt);
                }
                this.createNewBags = false;
            }
            Result baseInp = this.processInput();
            switch (baseInp.returnStatus) {
                case 0: {
                    rearranged = this.applyLRon((Tuple)baseInp.result, 0);
                    break;
                }
                case 3: {
                    Tuple topOfHeap2;
                    if (!this.parentPlan.endOfAllInput) {
                        return baseInp;
                    }
                    if (this.lastTime) {
                        return baseInp;
                    }
                    while (!this.heap.isEmpty() && !this.needToBreak(topOfHeap2 = this.heap.peek(), this.prevTopOfHeap)) {
                        Tuple nxtTuple;
                        this.workingOnNewKey = false;
                        topOfHeap2 = this.heap.poll();
                        byte relIdx = (Byte)topOfHeap2.get(0);
                        this.prevTopOfHeap = topOfHeap2;
                        this.outBags[relIdx].add((Tuple)topOfHeap2.get(2));
                        if (relIdx == 0 || (nxtTuple = this.sideLoaders.get(relIdx - 1).getNext()) == null) continue;
                        Tuple rearrangedTup = this.applyLRon(nxtTuple, relIdx);
                        Object key = rearrangedTup.get(1);
                        if (null != this.firstKeyOfNextSplit && null != key && this.firstKeyOfNextSplit.compareTo(key) <= 0) continue;
                        this.heap.offer(rearrangedTup);
                    }
                    if (this.heap.isEmpty() || this.firstKeyOfNextSplit != null && this.firstKeyOfNextSplit.compareTo(this.heap.peek().get(1)) <= 0) {
                        this.lastTime = true;
                    }
                    return this.getOutputTuple();
                }
                default: {
                    return baseInp;
                }
            }
            this.heap.offer(rearranged);
            if (this.firstTime) {
                this.setup(rearranged);
                this.firstTime = false;
            }
            while (!this.heap.isEmpty() && !this.needToBreak(topOfHeap = this.heap.peek(), this.prevTopOfHeap)) {
                this.workingOnNewKey = false;
                topOfHeap = this.heap.poll();
                byte relIdx = (Byte)topOfHeap.get(0);
                this.prevTopOfHeap = topOfHeap;
                this.outBags[relIdx].add((Tuple)topOfHeap.get(2));
                if (relIdx == 0) {
                    Tuple tuple = this.heap.peek();
                    if (null != tuple && (Byte)tuple.get(0) == 0) {
                        if (this.prevTopOfHeap.get(1) == null && tuple.get(1) == null) {
                            return new Result(this.endOfRecordMark, null);
                        }
                        if (this.prevTopOfHeap.get(1) == null && tuple.get(1) != null || !tuple.get(1).equals(this.prevTopOfHeap.get(1))) {
                            return this.getOutputTuple();
                        }
                    }
                    return new Result(this.endOfRecordMark, null);
                }
                Tuple nxtTuple = this.sideLoaders.get(relIdx - 1).getNext();
                if (nxtTuple == null) continue;
                Tuple rearrangedTup = this.applyLRon(nxtTuple, relIdx);
                Object key = rearrangedTup.get(1);
                if (this.firstKeyOfNextSplit != null && null != key && this.firstKeyOfNextSplit.compareTo(key) <= 0) continue;
                this.heap.offer(rearrangedTup);
            }
            return this.getOutputTuple();
        }
        catch (IOException ioe) {
            throw new ExecException(ioe);
        }
    }

    private Result getOutputTuple() throws ExecException {
        this.workingOnNewKey = true;
        this.createNewBags = true;
        Tuple out = this.mTupleFactory.newTuple(this.relationCnt + 1);
        out.set(0, this.prevTopOfHeap.get(1));
        for (int i = 0; i < this.relationCnt; ++i) {
            out.set(i + 1, this.outBags[i]);
        }
        return new Result(0, out);
    }

    private boolean needToBreak(Tuple curTopOfHeap, Tuple prevTopOfHeap) throws ExecException {
        if (this.workingOnNewKey) {
            return false;
        }
        Object curKey = curTopOfHeap.get(1);
        Object prevKey = prevTopOfHeap.get(1);
        if (curKey == null && null == prevKey) {
            return !((Byte)curTopOfHeap.get(0)).equals((Byte)prevTopOfHeap.get(0));
        }
        if (curKey == null || null == prevKey) {
            return true;
        }
        return !curKey.equals(prevKey);
    }

    private void setup(Tuple firstRearrangedTup) throws IOException {
        int curSplitIdx = 0;
        curSplitIdx = PigMapReduce.sJobContext.getConfiguration().get("pig.split.index") != null ? Integer.parseInt(PigMapReduce.sJobContext.getConfiguration().get("pig.split.index")) : ((PigSplit)((Mapper.Context)PigMapReduce.sJobContext).getInputSplit()).getSplitIndex();
        Object firstBaseKey = firstRearrangedTup.get(1);
        List<Pair<Integer, Tuple>> index = this.readIndex();
        this.firstKeyOfNextSplit = this.getFirstKeyOfNextSplit(curSplitIdx, index);
        block0: for (int i = 0; i < this.relationCnt - 1; ++i) {
            Tuple rearranged;
            Tuple t;
            LoadFunc loadfunc = (LoadFunc)PigContext.instantiateFuncFromSpec(this.sidFuncSpecs.get(i));
            loadfunc.setUDFContextSignature(this.loaderSignatures.get(i));
            Job dummyJob = new Job(new Configuration((Configuration)PigMapReduce.sJobConfInternal.get()));
            loadfunc.setLocation(this.sideFileSpecs.get(i), dummyJob);
            ((IndexableLoadFunc)((Object)loadfunc)).initialize(dummyJob.getConfiguration());
            this.sideLoaders.add(loadfunc);
            if (((Integer)index.get((int)0).first).equals(curSplitIdx)) {
                t = loadfunc.getNext();
                if (null == t) continue;
                rearranged = this.applyLRon(t, i + 1);
                this.heap.offer(rearranged);
                continue;
            }
            ((IndexableLoadFunc)((Object)loadfunc)).seekNear(firstBaseKey instanceof Tuple ? (Tuple)firstBaseKey : this.mTupleFactory.newTuple(firstBaseKey));
            while ((t = loadfunc.getNext()) != null) {
                int cmpVal;
                rearranged = this.applyLRon(t, i + 1);
                if (rearranged.get(1) == null || (cmpVal = ((Comparable)rearranged.get(1)).compareTo(firstBaseKey)) < 0) continue;
                if (this.firstKeyOfNextSplit != null && this.firstKeyOfNextSplit.compareTo(rearranged.get(1)) <= 0) continue block0;
                this.heap.offer(rearranged);
                continue block0;
            }
        }
    }

    private List<Pair<Integer, Tuple>> readIndex() throws ExecException {
        POLoad ld = new POLoad(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), new FileSpec(this.indexFileName, this.idxFuncSpec));
        Properties props = ConfigurationUtil.getLocalFSProperties();
        ld.setPc(new PigContext(ExecType.LOCAL, props));
        ArrayList<Pair<Integer, Tuple>> index = new ArrayList<Pair<Integer, Tuple>>();
        Result res = ld.getNextTuple();
        while (res.returnStatus != 3) {
            Tuple idxTuple = (Tuple)res.result;
            int colCnt = idxTuple.size() - 2;
            Tuple keyTuple = this.mTupleFactory.newTuple(colCnt);
            for (int i = 0; i < colCnt; ++i) {
                keyTuple.set(i, idxTuple.get(i));
            }
            index.add(new Pair<Integer, Tuple>((Integer)idxTuple.get(colCnt + 1), keyTuple));
            res = ld.getNextTuple();
        }
        return index;
    }

    private Comparable<Object> getFirstKeyOfNextSplit(int curSplitIdx, List<Pair<Integer, Tuple>> index) throws IOException {
        int i;
        for (i = 0; i < index.size() && !((Integer)index.get((int)i).first).equals(curSplitIdx); ++i) {
        }
        if (i < index.size() - 1) {
            Tuple keyTuple = (Tuple)index.get((int)(i + 1)).second;
            return keyTuple.size() == 1 ? (Comparable)keyTuple.get(0) : keyTuple;
        }
        return null;
    }

    private Tuple applyLRon(Tuple inp, int lrIdx) throws ExecException {
        POLocalRearrange lr = this.LRs[lrIdx];
        lr.attachInput(inp);
        Result lrOut = lr.getNextTuple();
        if (lrOut.returnStatus != 0) {
            int errCode = 2167;
            String errMsg = "LocalRearrange used to extract keys from tuple isn't configured correctly";
            throw new ExecException(errMsg, errCode, 4);
        }
        lr.detachInput();
        return this.mTupleFactory.newTuple(((Tuple)lrOut.result).getAll());
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitMergeCoGroup(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "MergeCogroup[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public List<PhysicalPlan> getLRInnerPlansOf(int i) {
        return this.LRs[i].getPlans();
    }

    public void setSideLoadFuncs(List<FuncSpec> sideLoadFuncs) {
        this.sidFuncSpecs = sideLoadFuncs;
    }

    public void setSideFileSpecs(List<String> sideFileSpecs) {
        this.sideFileSpecs = sideFileSpecs;
    }

    public String getIndexFileName() {
        return this.indexFileName;
    }

    public void setIndexFileName(String indexFileName) {
        this.indexFileName = indexFileName;
    }

    public FuncSpec getIdxFuncSpec() {
        return this.idxFuncSpec;
    }

    public void setIdxFuncSpec(FuncSpec idxFileSpec) {
        this.idxFuncSpec = idxFileSpec;
    }

    public void setLoaderSignatures(List<String> loaderSignatures) {
        this.loaderSignatures = loaderSignatures;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, ExecException {
        is.defaultReadObject();
        this.mTupleFactory = TupleFactory.getInstance();
        this.heap = new PriorityQueue<Tuple>(11, new Comparator<Tuple>(){

            @Override
            public int compare(Tuple resLHS, Tuple resRHS) {
                try {
                    Object leftKey = resLHS.get(1);
                    Object rightKey = resRHS.get(1);
                    if (null == leftKey && null == rightKey) {
                        return ((Byte)resRHS.get(0)).compareTo((Byte)resLHS.get(0));
                    }
                    if (null == leftKey) {
                        return -1;
                    }
                    if (null == rightKey) {
                        return 1;
                    }
                    int cmpval = ((Comparable)leftKey).compareTo(rightKey);
                    return cmpval == 0 ? ((Byte)resRHS.get(0)).compareTo((Byte)resLHS.get(0)) : cmpval;
                }
                catch (ExecException e) {
                    String errMsg = "Exception occured in compare() of heap in POMergeCogroup.";
                    throw new RuntimeException(errMsg, e);
                }
            }
        });
        this.createNewBags = true;
        this.lastTime = false;
        this.relationCnt = this.LRs.length;
        this.outBags = new DataBag[this.relationCnt];
        this.firstTime = true;
        this.workingOnNewKey = true;
        this.sideLoaders = new ArrayList<LoadFunc>();
    }

    private void printHeap() {
        System.out.println("Printing heap :" + ++this.counter);
        PriorityQueue<Tuple> copy = new PriorityQueue<Tuple>(this.heap);
        System.out.println("Heap size: " + this.heap.size());
        int i = 0;
        while (!copy.isEmpty()) {
            System.out.println(i++ + "th item in heap: " + copy.poll());
        }
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }
}

