/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.SelfSpillBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.GroupingSpillable;
import org.apache.pig.impl.util.Spillable;
import org.apache.pig.impl.util.SpillableMemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POPartialAgg
extends PhysicalOperator
implements Spillable,
GroupingSpillable {
    private static final Log LOG = LogFactory.getLog(POPartialAgg.class);
    private static final long serialVersionUID = 1L;
    private static final Result EOP_RESULT = new Result(3, null);
    private static final int NUM_RECS_TO_SAMPLE = 10000;
    private static final int MAX_LIST_SIZE = 9368;
    private static final int DEFAULT_MIN_REDUCTION = 10;
    private static final int FIRST_TIER_THRESHOLD = 20000;
    private static final int SECOND_TIER_THRESHOLD = 2000;
    private static final WeakHashMap<POPartialAgg, Byte> ALL_POPARTS = new WeakHashMap();
    private static final TupleFactory TF = TupleFactory.getInstance();
    private PhysicalPlan keyPlan;
    private ExpressionOperator keyLeaf;
    private List<PhysicalPlan> valuePlans;
    private List<ExpressionOperator> valueLeaves;
    private transient int numRecsInRawMap;
    private transient int numRecsInProcessedMap;
    private transient Map<Object, List<Tuple>> rawInputMap;
    private transient Map<Object, List<Tuple>> processedInputMap;
    private transient boolean initialized;
    private transient boolean disableMapAgg;
    private transient boolean sizeReductionChecked;
    private transient boolean inputsExhausted;
    private transient boolean estimatedMemThresholds;
    private volatile transient boolean doSpill;
    private volatile transient boolean doContingentSpill;
    private volatile transient Object spillLock;
    private transient int minOutputReduction;
    private transient float percentUsage;
    private transient int numRecordsToSample;
    private transient int firstTierThreshold;
    private transient int secondTierThreshold;
    private transient int sizeReduction;
    private transient int avgTupleSize;
    private transient Iterator<Map.Entry<Object, List<Tuple>>> spillingIterator;

    public POPartialAgg(OperatorKey k) {
        super(k);
    }

    private void init() throws ExecException {
        ALL_POPARTS.put(this, null);
        this.numRecsInRawMap = 0;
        this.numRecsInProcessedMap = 0;
        this.rawInputMap = Maps.newHashMap();
        this.processedInputMap = Maps.newHashMap();
        this.minOutputReduction = 10;
        this.numRecordsToSample = 10000;
        this.firstTierThreshold = 20000;
        this.secondTierThreshold = 2000;
        this.sizeReduction = 1;
        this.avgTupleSize = 0;
        this.percentUsage = 0.2f;
        this.spillLock = new Object();
        if (PigMapReduce.sJobConfInternal.get() != null) {
            String usage = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.memusage");
            if (usage != null) {
                this.percentUsage = Float.parseFloat(usage);
            }
            this.minOutputReduction = ((Configuration)PigMapReduce.sJobConfInternal.get()).getInt("pig.exec.mapPartAgg.minReduction", 10);
            if (this.minOutputReduction <= 0) {
                LOG.info((Object)("Specified reduction is < 0 (" + this.minOutputReduction + "). Using default " + 10));
                this.minOutputReduction = 10;
            }
        }
        if (this.percentUsage <= 0.0f) {
            LOG.info((Object)"No memory allocated to intermediate memory buffers. Turning off partial aggregation.");
            this.disableMapAgg();
            this.sizeReductionChecked = true;
            this.estimatedMemThresholds = true;
        }
        this.initialized = true;
        SpillableMemoryManager.getInstance().registerSpillable(this);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (!this.initialized && !ALL_POPARTS.containsKey(this)) {
            this.init();
        }
        while (true) {
            if (!this.sizeReductionChecked && this.numRecsInRawMap >= this.numRecordsToSample) {
                this.checkSizeReduction();
                if (this.doContingentSpill && !this.doSpill) {
                    LOG.info((Object)"Avoided emitting records during spill memory call.");
                    this.doContingentSpill = false;
                }
            }
            if (!this.estimatedMemThresholds && this.numRecsInRawMap >= this.numRecordsToSample) {
                this.estimateMemThresholds();
            }
            if (this.doContingentSpill && !this.doSpill) {
                this.aggregateBothLevels(false, false);
                if (this.shouldSpill()) {
                    this.startSpill(false);
                } else {
                    LOG.info((Object)"Avoided emitting records during spill memory call.");
                    this.doContingentSpill = false;
                }
            }
            if (this.doSpill) {
                this.startSpill(true);
                Result result = this.spillResult();
                if (result.returnStatus == 3) {
                    this.doSpill = false;
                    this.doContingentSpill = false;
                }
                if (result.returnStatus != 3 || this.inputsExhausted) {
                    return result;
                }
            }
            if (this.mapAggDisabled()) {
                return this.processInput();
            }
            Result inp = this.processInput();
            if (inp.returnStatus == 2) {
                return inp;
            }
            if (inp.returnStatus == 3) {
                if (this.parentPlan.endOfAllInput) {
                    this.inputsExhausted = true;
                    LOG.info((Object)"Spilling last bits.");
                    this.startSpill(true);
                    continue;
                }
                return EOP_RESULT;
            }
            if (inp.returnStatus == 1) continue;
            Tuple inpTuple = (Tuple)inp.result;
            this.keyPlan.attachInput(inpTuple);
            Result keyRes = this.getResult(this.keyLeaf);
            if (keyRes.returnStatus != 0) {
                return keyRes;
            }
            Object key = keyRes.result;
            this.keyPlan.detachInput();
            ++this.numRecsInRawMap;
            this.addKeyValToMap(this.rawInputMap, key, inpTuple);
            this.aggregateBothLevels(true, true);
            if (!this.shouldSpill()) continue;
            this.startSpill(false);
        }
    }

    private void estimateMemThresholds() {
        if (!this.mapAggDisabled()) {
            LOG.info((Object)("Getting mem limits; considering " + ALL_POPARTS.size() + " POPArtialAgg objects." + " with memory percentage " + this.percentUsage));
            SelfSpillBag.MemoryLimits memLimits = new SelfSpillBag.MemoryLimits(ALL_POPARTS.size(), this.percentUsage);
            int estTotalMem = 0;
            int estTuples = 0;
            for (Map.Entry<Object, List<Tuple>> entry : this.rawInputMap.entrySet()) {
                for (Tuple t : entry.getValue()) {
                    ++estTuples;
                    int mem = (int)t.getMemorySize();
                    estTotalMem += mem;
                    memLimits.addNewObjSize(mem);
                }
            }
            this.avgTupleSize = estTotalMem / estTuples;
            long totalTuples = memLimits.getCacheLimit();
            LOG.info((Object)("Estimated total tuples to buffer, based on " + estTuples + " tuples that took up " + estTotalMem + " bytes: " + totalTuples));
            this.firstTierThreshold = (int)(0.5 + (double)((float)totalTuples * (1.0f - 1.0f / (float)this.sizeReduction)));
            this.secondTierThreshold = (int)(0.5 + (double)((float)totalTuples * (1.0f / (float)this.sizeReduction)));
            LOG.info((Object)("Setting thresholds. Primary: " + this.firstTierThreshold + ". Secondary: " + this.secondTierThreshold));
            if (this.secondTierThreshold == 0) {
                ++this.secondTierThreshold;
                --this.firstTierThreshold;
            }
        }
        this.estimatedMemThresholds = true;
    }

    private void checkSizeReduction() throws ExecException {
        if (!this.mapAggDisabled()) {
            int numBeforeReduction = this.numRecsInProcessedMap + this.numRecsInRawMap;
            this.aggregateBothLevels(false, false);
            int numAfterReduction = this.numRecsInProcessedMap + this.numRecsInRawMap;
            LOG.info((Object)("After reduction, processed map: " + this.numRecsInProcessedMap + "; raw map: " + this.numRecsInRawMap));
            LOG.info((Object)("Observed reduction factor: from " + numBeforeReduction + " to " + numAfterReduction + " => " + numBeforeReduction / numAfterReduction + "."));
            if (numBeforeReduction / numAfterReduction < this.minOutputReduction) {
                LOG.info((Object)("Disabling in-memory aggregation, since observed reduction is less than " + this.minOutputReduction));
                this.disableMapAgg();
            }
            this.sizeReduction = numBeforeReduction / numAfterReduction;
            this.sizeReductionChecked = true;
        }
    }

    private void disableMapAgg() throws ExecException {
        this.startSpill(false);
        this.disableMapAgg = true;
    }

    private boolean mapAggDisabled() {
        return this.disableMapAgg;
    }

    private boolean shouldAggregateFirstLevel() {
        return this.numRecsInRawMap > this.firstTierThreshold;
    }

    private boolean shouldAggregateSecondLevel() {
        return this.numRecsInProcessedMap > this.secondTierThreshold;
    }

    private boolean shouldSpill() {
        return this.shouldAggregateSecondLevel();
    }

    private void addKeyValToMap(Map<Object, List<Tuple>> map, Object key, Tuple inpTuple) throws ExecException {
        List<Tuple> value = map.get(key);
        if (value == null) {
            value = new ArrayList<Tuple>();
            map.put(key, value);
        }
        value.add(inpTuple);
        if (value.size() >= 9368) {
            boolean isFirst;
            boolean bl = isFirst = map == this.rawInputMap;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The cache for key " + key + " has grown too large. Aggregating " + (isFirst ? "first level." : "second level.")));
            }
            if (isFirst) {
                this.aggregateRawRow(key);
            } else {
                this.aggregateSecondLevel();
            }
        }
    }

    private void startSpill(boolean aggregate) throws ExecException {
        if (this.spillingIterator != null) {
            return;
        }
        LOG.info((Object)"Starting spill.");
        if (aggregate) {
            this.aggregateBothLevels(false, true);
        }
        this.doSpill = true;
        this.spillingIterator = this.processedInputMap.entrySet().iterator();
    }

    private Result spillResult() throws ExecException {
        if (this.processedInputMap.isEmpty()) {
            this.spillingIterator = null;
            LOG.info((Object)"In spillResults(), processed map is empty -- done spilling.");
            return EOP_RESULT;
        }
        Map.Entry<Object, List<Tuple>> entry = this.spillingIterator.next();
        Tuple valueTuple = this.createValueTuple(entry.getKey(), entry.getValue());
        this.numRecsInProcessedMap -= entry.getValue().size();
        this.spillingIterator.remove();
        Result res = this.getOutput(entry.getKey(), valueTuple);
        return res;
    }

    private void aggregateRawRow(Object key) throws ExecException {
        List<Tuple> value = this.rawInputMap.get(key);
        Tuple valueTuple = this.createValueTuple(key, value);
        Result res = this.getOutput(key, valueTuple);
        this.rawInputMap.remove(key);
        this.addKeyValToMap(this.processedInputMap, key, this.getAggResultTuple(res.result));
        ++this.numRecsInProcessedMap;
    }

    private int aggregate(Map<Object, List<Tuple>> fromMap, Map<Object, List<Tuple>> toMap, int numEntriesInTarget) throws ExecException {
        Iterator<Map.Entry<Object, List<Tuple>>> iter = fromMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, List<Tuple>> entry = iter.next();
            Tuple valueTuple = this.createValueTuple(entry.getKey(), entry.getValue());
            Result res = this.getOutput(entry.getKey(), valueTuple);
            iter.remove();
            this.addKeyValToMap(toMap, entry.getKey(), this.getAggResultTuple(res.result));
            ++numEntriesInTarget;
        }
        return numEntriesInTarget;
    }

    private void aggregateBothLevels(boolean checkThresholdForFirst, boolean checkThresholdForSecond) throws ExecException {
        boolean aggregateSecondLevel;
        boolean bl = aggregateSecondLevel = !this.processedInputMap.isEmpty();
        if (!checkThresholdForFirst || this.shouldAggregateFirstLevel()) {
            this.aggregateFirstLevel();
        }
        if (aggregateSecondLevel && (!checkThresholdForSecond || this.shouldAggregateSecondLevel())) {
            this.aggregateSecondLevel();
        }
    }

    private void aggregateFirstLevel() throws ExecException {
        if (this.rawInputMap.isEmpty()) {
            return;
        }
        int rawTuples = this.numRecsInRawMap;
        int processedTuples = this.numRecsInProcessedMap;
        this.numRecsInProcessedMap = this.aggregate(this.rawInputMap, this.processedInputMap, this.numRecsInProcessedMap);
        this.numRecsInRawMap = 0;
        LOG.info((Object)("Aggregated " + rawTuples + " raw tuples." + " Processed tuples before aggregation = " + processedTuples + ", after aggregation = " + this.numRecsInProcessedMap));
    }

    private void aggregateSecondLevel() throws ExecException {
        if (this.processedInputMap.isEmpty()) {
            return;
        }
        int processedTuples = this.numRecsInProcessedMap;
        HashMap newMap = Maps.newHashMapWithExpectedSize((int)this.processedInputMap.size());
        this.numRecsInProcessedMap = this.aggregate(this.processedInputMap, newMap, 0);
        this.processedInputMap = newMap;
        LOG.info((Object)("Aggregated " + processedTuples + " processed tuples to " + this.numRecsInProcessedMap + " tuples"));
    }

    private Tuple createValueTuple(Object key, List<Tuple> inpTuples) throws ExecException {
        Tuple valueTuple = TF.newTuple(this.valuePlans.size() + 1);
        valueTuple.set(0, key);
        for (int i = 0; i < this.valuePlans.size(); ++i) {
            InternalCachedBag bag = null;
            bag = this.doContingentSpill ? new InternalCachedBag() : new InternalCachedBag(1, 0.1f);
            valueTuple.set(i + 1, bag);
        }
        for (Tuple t : inpTuples) {
            for (int i = 1; i < t.size(); ++i) {
                DataBag bag = (DataBag)valueTuple.get(i);
                bag.add((Tuple)t.get(i));
            }
        }
        return valueTuple;
    }

    private Tuple getAggResultTuple(Object result) throws ExecException {
        try {
            return (Tuple)result;
        }
        catch (ClassCastException ex) {
            throw new ExecException("Intermediate Algebraic functions must implement EvalFunc<Tuple>");
        }
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPartialAgg(this);
    }

    private Result getResult(ExpressionOperator op) throws ExecException {
        Result res;
        switch (op.getResultType()) {
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 30: 
            case 50: 
            case 55: 
            case 65: 
            case 70: 
            case 100: 
            case 110: 
            case 120: {
                res = op.getNext(op.getResultType());
                break;
            }
            default: {
                String msg = "Invalid result type: " + DataType.findType(op.getResultType());
                throw new ExecException(msg, 2270, 4);
            }
        }
        return res;
    }

    private Result getOutput(Object key, Tuple value) throws ExecException {
        Tuple output = TF.newTuple(this.valuePlans.size() + 1);
        output.set(0, key);
        for (int i = 0; i < this.valuePlans.size(); ++i) {
            this.valuePlans.get(i).attachInput(value);
            Result valRes = this.getResult(this.valueLeaves.get(i));
            if (valRes.returnStatus == 2) {
                return valRes;
            }
            output.set(i + 1, valRes.result);
        }
        return new Result(0, output);
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Partial Agg" + "[" + DataType.findTypeName(this.resultType) + "]" + this.mKey.toString();
    }

    public PhysicalPlan getKeyPlan() {
        return this.keyPlan;
    }

    public void setKeyPlan(PhysicalPlan keyPlan) {
        this.keyPlan = keyPlan;
        this.keyLeaf = (ExpressionOperator)keyPlan.getLeaves().get(0);
    }

    public List<PhysicalPlan> getValuePlans() {
        return this.valuePlans;
    }

    public void setValuePlans(List<PhysicalPlan> valuePlans) {
        this.valuePlans = valuePlans;
        this.valueLeaves = new ArrayList<ExpressionOperator>();
        for (PhysicalPlan plan : valuePlans) {
            this.valueLeaves.add((ExpressionOperator)plan.getLeaves().get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long spill() {
        if (this.mapAggDisabled()) {
            return 0L;
        }
        LOG.info((Object)"Spill triggered by SpillableMemoryManager");
        this.doContingentSpill = true;
        Object object = this.spillLock;
        synchronized (object) {
            if (!this.sizeReductionChecked) {
                this.numRecordsToSample = this.numRecsInRawMap;
            }
            try {
                while (this.doContingentSpill) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted exception while waiting for spill to finish", (Throwable)e);
            }
            LOG.info((Object)"Finished spill for SpillableMemoryManager call");
            return 1L;
        }
    }

    @Override
    public long getMemorySize() {
        return this.avgTupleSize * (this.numRecsInProcessedMap + this.numRecsInRawMap);
    }
}

