/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.util;

import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class ParallelConstantVisitor
extends PhyPlanVisitor {
    private int rp;
    private boolean replaced = false;

    public ParallelConstantVisitor(PhysicalPlan plan, int rp) {
        super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        this.rp = rp;
    }

    public void visitConstant(ConstantExpression cnst) throws VisitorException {
        Object obj = cnst.getValue();
        if (obj instanceof Integer) {
            if (this.replaced) {
                throw new VisitorException("Invalid reduce plan: more than one ConstantExpression found in sampling job");
            }
            cnst.setValue(this.rp);
            cnst.setRequestedParallelism(this.rp);
            this.replaced = true;
        }
    }
}

