/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.FilterFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bloom
extends FilterFunc {
    private String bloomFile;
    public BloomFilter filter = null;

    public Bloom(String filename) {
        this.bloomFile = filename;
    }

    @Override
    public Boolean exec(Tuple input) throws IOException {
        if (this.filter == null) {
            this.init();
        }
        byte[] b = input.size() == 1 ? DataType.toBytes(input.get(0)) : DataType.toBytes(input, (byte)110);
        Key k = new Key(b);
        return this.filter.membershipTest(k);
    }

    @Override
    public List<String> getCacheFiles() {
        ArrayList<String> list = new ArrayList<String>(1);
        try {
            list.add(this.bloomFile + "#" + this.getFilenameFromPath(this.bloomFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        this.filter = new BloomFilter();
        String dir = "./" + this.getFilenameFromPath(this.bloomFile);
        String[] partFiles = new File(dir).list(new FilenameFilter(){

            public boolean accept(File current, String name) {
                return name.startsWith("part");
            }
        });
        String dcFile = dir + "/" + partFiles[0];
        DataInputStream dis = new DataInputStream(new FileInputStream(dcFile));
        try {
            this.filter.readFields((DataInput)dis);
        }
        finally {
            dis.close();
        }
    }

    public void setFilter(DataByteArray dba) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dba.get()));
        this.filter = new BloomFilter();
        this.filter.readFields((DataInput)dis);
    }

    private String getFilenameFromPath(String p) throws IOException {
        Path path = new Path(p);
        return path.toUri().getPath().replace("/", "_");
    }
}

