/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleRoundTo
extends EvalFunc<Double> {
    @Override
    public Double exec(Tuple input) throws IOException {
        if (input == null || input.size() < 2) {
            return null;
        }
        try {
            RoundingMode mode;
            Double num = (Double)input.get(0);
            Integer digits = (Integer)input.get(1);
            RoundingMode roundingMode = mode = input.size() >= 3 ? RoundingMode.valueOf(DataType.toInteger(input.get(2))) : RoundingMode.HALF_EVEN;
            if (num == null) {
                return null;
            }
            BigDecimal bdnum = BigDecimal.valueOf(num);
            bdnum = bdnum.setScale((int)digits, mode);
            return bdnum.doubleValue();
        }
        catch (Exception e) {
            throw new IOException("Caught exception processing input row ", e);
        }
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s_dbl_2 = new Schema();
        s_dbl_2.add(new Schema.FieldSchema(null, 25));
        s_dbl_2.add(new Schema.FieldSchema(null, 10));
        Schema s_dbl_3 = new Schema();
        s_dbl_3.add(new Schema.FieldSchema(null, 25));
        s_dbl_3.add(new Schema.FieldSchema(null, 10));
        s_dbl_3.add(new Schema.FieldSchema(null, 10));
        funcList.add(new FuncSpec(this.getClass().getName(), s_dbl_2));
        funcList.add(new FuncSpec(this.getClass().getName(), s_dbl_3));
        return funcList;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

