/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.EvalFunc;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INDEXOF
extends EvalFunc<Integer> {
    private static final Log log = LogFactory.getLog(INDEXOF.class);

    @Override
    public Integer exec(Tuple input) throws IOException {
        if (input == null || input.size() < 2) {
            this.warn("invalid input tuple: " + input, PigWarning.UDF_WARNING_1);
            return null;
        }
        try {
            String str = (String)input.get(0);
            String search = (String)input.get(1);
            int fromIndex = 0;
            if (input.size() >= 3) {
                fromIndex = (Integer)input.get(2);
            }
            return str.indexOf(search, fromIndex);
        }
        catch (Exception e) {
            this.warn("Failed to process input; error - " + e.getMessage(), PigWarning.UDF_WARNING_1);
            return null;
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 10));
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

