/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.CubeDimensions;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollupDimensions
extends EvalFunc<DataBag> {
    private static BagFactory bf = BagFactory.getInstance();
    private static TupleFactory tf = TupleFactory.getInstance();
    private final String allMarker;

    public RollupDimensions() {
        this(null);
    }

    public RollupDimensions(String allMarker) {
        this.allMarker = allMarker;
    }

    @Override
    public DataBag exec(Tuple tuple) throws IOException {
        ArrayList result = Lists.newArrayListWithCapacity((int)(tuple.size() + 1));
        CubeDimensions.convertNullToUnknown(tuple);
        result.add(tuple);
        this.iterativelyRollup(result, tuple);
        return bf.newDefaultBag(result);
    }

    private void iterativelyRollup(List<Tuple> result, Tuple input) throws ExecException {
        Tuple tempTup = tf.newTuple(input.getAll());
        for (int i = input.size() - 1; i >= 0; --i) {
            tempTup.set(i, this.allMarker);
            result.add(tf.newTuple(tempTup.getAll()));
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema("dimensions", input, 120));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

