/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConcat
extends EvalFunc<String> {
    @Override
    public String exec(Tuple input) throws IOException {
        try {
            if (input == null || input.size() == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < input.size(); ++i) {
                if (input.get(i) == null) {
                    return null;
                }
                sb.append(String.valueOf(input.get(i)));
            }
            return sb.toString();
        }
        catch (ExecException exp) {
            throw exp;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing concat in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 55));
    }

    @Override
    public EvalFunc.SchemaType getSchemaType() {
        return EvalFunc.SchemaType.VARARG;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

