/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Level;
import org.apache.pig.ExecType;
import org.apache.pig.ExecTypeProvider;
import org.apache.pig.FuncSpec;
import org.apache.pig.JVMReuseManager;
import org.apache.pig.PigException;
import org.apache.pig.StaticDataCleanup;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.DataStorageException;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecutionEngine;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;
import org.apache.pig.impl.streaming.ExecutableManager;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.apache.pig.tools.parameters.ParseException;
import org.apache.pig.tools.parameters.PreprocessorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PigContext.class);
    public static final String JOB_NAME = "jobName";
    public static final String JOB_NAME_PREFIX = "PigLatin";
    public static final String JOB_PRIORITY = "jobPriority";
    public static final String PIG_CMD_ARGS_REMAINDERS = "pig.cmd.args.remainders";
    private ExecType execType;
    private transient DataStorage dfs;
    private transient DataStorage lfs;
    private transient ExecutionEngine executionEngine;
    private Properties properties;
    public transient List<URL> extraJars = new LinkedList<URL>();
    private transient Map<URL, String> extraJarOriginalPaths = new HashMap<URL, String>();
    public transient List<String> scriptJars = new ArrayList<String>(2);
    public transient Vector<String> predeployedJars = new Vector(2);
    @Deprecated
    public List<String> scriptFiles = new ArrayList<String>();
    private Map<String, File> aliasedScriptFiles = new LinkedHashMap<String, File>();
    public transient Map<String, String> scriptingUDFs;
    public transient Map<String, Tree> macros;
    private Map<String, FuncSpec> definedFunctions = new HashMap<String, FuncSpec>();
    private Map<String, StreamingCommand> definedCommands = new HashMap<String, StreamingCommand>();
    private static ThreadLocal<ArrayList<String>> packageImportList = new ThreadLocal();
    private static ThreadLocal<Map<String, Class<?>>> classCache = new ThreadLocal();
    private Properties log4jProperties = new Properties();
    private Level defaultLogLevel = Level.INFO;
    public int defaultParallel = -1;
    public boolean inExplain = false;
    public boolean inDumpSchema = false;
    public boolean inIllustrator = false;
    private String last_alias = null;
    List<String> skippedShipPaths = new ArrayList<String>();
    private static ContextClassLoader classloader;
    private List<String> params;
    private List<String> paramFiles;
    private transient PreprocessorContext preprocessorContext = new PreprocessorContext(50);

    @StaticDataCleanup
    public static void staticDataCleanup() {
        packageImportList.set(null);
    }

    public List<String> getParams() {
        return this.params;
    }

    public void setParams(List<String> params) {
        this.params = params;
    }

    public List<String> getParamFiles() {
        return this.paramFiles;
    }

    public void setParamFiles(List<String> paramFiles) {
        this.paramFiles = paramFiles;
    }

    public PreprocessorContext getPreprocessorContext() {
        return this.preprocessorContext;
    }

    public Map<String, String> getParamVal() throws IOException {
        Map<String, String> paramVal = this.preprocessorContext.getParamVal();
        if (paramVal == null) {
            try {
                this.preprocessorContext.loadParamVal(this.params, this.paramFiles);
            }
            catch (ParseException e) {
                throw new IOException(e.getMessage());
            }
            return this.preprocessorContext.getParamVal();
        }
        return paramVal;
    }

    public PigContext() {
        this(ExecType.MAPREDUCE, new Properties());
    }

    public PigContext(Configuration conf) throws PigException {
        this(ConfigurationUtil.toProperties(conf));
    }

    public PigContext(Properties properties) throws PigException {
        this(ExecTypeProvider.selectExecType(properties), properties);
    }

    public PigContext(ExecType execType, Configuration conf) {
        this(execType, ConfigurationUtil.toProperties(conf));
    }

    public PigContext(ExecType execType, Properties properties) {
        this.execType = execType;
        this.properties = properties;
        this.properties.setProperty("exectype", this.execType.name());
        this.executionEngine = execType.getExecutionEngine(this);
        this.skippedShipPaths.add("/bin");
        this.skippedShipPaths.add("/usr/bin");
        this.skippedShipPaths.add("/usr/local/bin");
        this.skippedShipPaths.add("/sbin");
        this.skippedShipPaths.add("/usr/sbin");
        this.skippedShipPaths.add("/usr/local/sbin");
        this.macros = new HashMap<String, Tree>();
        this.scriptingUDFs = new HashMap<String, String>();
        this.init();
    }

    private void init() {
        if (this.properties.get("udf.import.list") != null) {
            PigContext.initializeImportList((String)this.properties.get("udf.import.list"));
        }
    }

    public static void initializeImportList(String importListCommandLineProperties) {
        StringTokenizer tokenizer = new StringTokenizer(importListCommandLineProperties, ":");
        int pos = 1;
        ArrayList<String> importList = PigContext.getPackageImportList();
        while (tokenizer.hasMoreTokens()) {
            String importItem = tokenizer.nextToken();
            if (!importItem.endsWith(".")) {
                importItem = importItem + ".";
            }
            importList.add(pos, importItem);
            ++pos;
        }
    }

    public void connect() throws ExecException {
        this.executionEngine.init();
        this.dfs = this.executionEngine.getDataStorage();
        this.lfs = new HDataStorage(URI.create("file:///"), this.properties);
    }

    public void setJobtrackerLocation(String newLocation) {
        this.executionEngine.setProperty("mapred.job.tracker", newLocation);
    }

    public void addScriptFile(String path) {
        this.addScriptFile(path, path);
    }

    public void addScriptFile(String name, String path) {
        if (path != null) {
            this.aliasedScriptFiles.put(name.replaceFirst("^/", "").replaceAll(":", ""), new File(path));
        }
    }

    public void addScriptJar(String path) {
        if (path != null && !this.scriptJars.contains(path)) {
            this.scriptJars.add(path);
        }
    }

    public void addJar(String path) throws MalformedURLException {
        if (path != null) {
            URL resource = new File(path).toURI().toURL();
            this.addJar(resource, path);
        }
    }

    public void addJar(URL resource, String originalPath) throws MalformedURLException {
        if (resource != null && !this.extraJars.contains(resource)) {
            this.extraJars.add(resource);
            this.extraJarOriginalPaths.put(resource, originalPath);
            classloader.addURL(resource);
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    public boolean hasJar(String path) {
        for (URL url : this.extraJars) {
            if (!this.extraJarOriginalPaths.get(url).equals(path)) continue;
            return true;
        }
        return false;
    }

    public void markJarAsPredeployed(String path) {
        if (path != null && !this.predeployedJars.contains(path)) {
            this.predeployedJars.add(path);
        }
    }

    public String doParamSubstitution(InputStream in, List<String> params, List<String> paramFiles) throws IOException {
        return this.doParamSubstitution(new BufferedReader(new InputStreamReader(in)), params, paramFiles);
    }

    public String doParamSubstitution(BufferedReader reader, List<String> params, List<String> paramFiles) throws IOException {
        this.params = params;
        this.paramFiles = paramFiles;
        return this.doParamSubstitution(reader);
    }

    public String doParamSubstitution(BufferedReader reader) throws IOException {
        try {
            this.preprocessorContext.setPigContext(this);
            this.preprocessorContext.loadParamVal(this.params, this.paramFiles);
            ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(this.preprocessorContext);
            StringWriter writer = new StringWriter();
            psp.genSubstitutedFile(reader, writer);
            return writer.toString();
        }
        catch (ParseException e) {
            log.error((Object)e.getLocalizedMessage());
            throw new IOException(e);
        }
    }

    public BufferedReader doParamSubstitutionOutputToFile(BufferedReader reader, String outputFilePath, List<String> params, List<String> paramFiles) throws IOException {
        this.params = params;
        this.paramFiles = paramFiles;
        return this.doParamSubstitutionOutputToFile(reader, outputFilePath);
    }

    public BufferedReader doParamSubstitutionOutputToFile(BufferedReader reader, String outputFilePath) throws IOException {
        try {
            this.preprocessorContext.loadParamVal(this.params, this.paramFiles);
            ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(this.preprocessorContext);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));
            psp.genSubstitutedFile(reader, writer);
            return new BufferedReader(new FileReader(outputFilePath));
        }
        catch (ParseException e) {
            log.error((Object)e.getLocalizedMessage());
            throw new IOException(e);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Could not find file to substitute parameters for: " + outputFilePath);
        }
    }

    public Map<String, File> getScriptFiles() {
        return this.aliasedScriptFiles;
    }

    public void rename(String oldName, String newName) throws IOException {
        if (oldName.equals(newName)) {
            return;
        }
        System.out.println("Renaming " + oldName + " to " + newName);
        ElementDescriptor dst = null;
        ElementDescriptor src = null;
        try {
            dst = this.dfs.asElement(newName);
            src = this.dfs.asElement(oldName);
        }
        catch (DataStorageException e) {
            byte errSrc = this.getErrorSource();
            int errCode = 0;
            switch (errSrc) {
                case 16: {
                    errCode = 6005;
                    break;
                }
                case 8: {
                    errCode = 4005;
                    break;
                }
                default: {
                    errCode = 2038;
                }
            }
            String msg = "Unable to rename " + oldName + " to " + newName;
            throw new ExecException(msg, errCode, errSrc, e);
        }
        if (dst.exists()) {
            dst.delete();
        }
        src.rename(dst);
    }

    public void copy(String src, String dst, boolean localDst) throws IOException {
        DataStorage dstStorage = this.dfs;
        if (localDst) {
            dstStorage = this.lfs;
        }
        ElementDescriptor srcElement = null;
        ElementDescriptor dstElement = null;
        try {
            srcElement = this.dfs.asElement(src);
            dstElement = dstStorage.asElement(dst);
        }
        catch (DataStorageException e) {
            byte errSrc = this.getErrorSource();
            int errCode = 0;
            switch (errSrc) {
                case 16: {
                    errCode = 6006;
                    break;
                }
                case 8: {
                    errCode = 4006;
                    break;
                }
                default: {
                    errCode = 2039;
                }
            }
            String msg = "Unable to copy " + src + " to " + dst;
            throw new ExecException(msg, errCode, errSrc, e);
        }
        srcElement.copy(dstElement, this.properties, false);
    }

    public ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public DataStorage getDfs() {
        return this.dfs;
    }

    public DataStorage getLfs() {
        return this.lfs;
    }

    public DataStorage getFs() {
        return this.dfs;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Deprecated
    public Properties getConf() {
        return this.getProperties();
    }

    public String getLastAlias() {
        return this.last_alias;
    }

    public void setLastAlias(String value) {
        this.last_alias = value;
    }

    public void registerFunction(String function, FuncSpec functionSpec) {
        if (functionSpec == null) {
            this.definedFunctions.remove(function);
        } else {
            this.definedFunctions.put(function, functionSpec);
        }
    }

    public void registerStreamCmd(String alias, StreamingCommand command) {
        if (command == null) {
            this.definedCommands.remove(alias);
        } else {
            this.definedCommands.put(alias, command);
        }
    }

    public ExecType getExecType() {
        return this.execType;
    }

    public ClassLoader createCl(String jarFile) throws MalformedURLException {
        int len = this.extraJars.size();
        int passedJar = jarFile == null ? 0 : 1;
        URL[] urls = new URL[len + passedJar];
        if (jarFile != null) {
            urls[0] = new URL("file:" + jarFile);
        }
        for (int i = 0; i < this.extraJars.size(); ++i) {
            urls[i + passedJar] = this.extraJars.get(i);
        }
        return new ContextClassLoader(urls, PigContext.class.getClassLoader());
    }

    private static Map<String, Class<?>> getClassCache() {
        Map<String, Class<?>> c = classCache.get();
        if (c == null) {
            c = new HashMap();
            classCache.set(c);
        }
        return c;
    }

    public static Class resolveClassName(String name) throws IOException {
        Map<String, Class<?>> cache = PigContext.getClassCache();
        Class<?> c = cache.get(name);
        if (c != null) {
            return c;
        }
        for (String prefix : PigContext.getPackageImportList()) {
            try {
                c = Class.forName(prefix + name, true, classloader);
                cache.put(name, c);
                return c;
            }
            catch (ClassNotFoundException e) {
            }
            catch (UnsupportedClassVersionError e) {
                int errCode = 1069;
                String msg = "Problem resolving class version numbers for class " + name;
                throw new ExecException(msg, errCode, 2, e);
            }
        }
        int errCode = 1070;
        String msg = "Could not resolve " + name + " using imports: " + packageImportList.get();
        throw new ExecException(msg, errCode, 2);
    }

    public static <T> T instantiateObjectFromParams(Configuration conf, String classParamKey, String argParamKey, Class<T> clazz) throws ExecException {
        String className = conf.get(classParamKey);
        if (className != null) {
            FuncSpec fs = conf.get(argParamKey) != null ? new FuncSpec(className, conf.get(argParamKey)) : new FuncSpec(className);
            try {
                return clazz.cast(PigContext.instantiateFuncFromSpec(fs));
            }
            catch (ClassCastException e) {
                throw new ExecException("The class defined by " + classParamKey + " in conf is not of type " + clazz.getName(), e);
            }
        }
        return null;
    }

    public static Object instantiateFuncFromSpec(FuncSpec funcSpec) {
        Object ret;
        String className = funcSpec.getClassName();
        Object[] args = funcSpec.getCtorArgs();
        Class objClass = null;
        try {
            objClass = PigContext.resolveClassName(className);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot instantiate: " + className, ioe);
        }
        try {
            if (args != null && args.length > 0) {
                Class[] paramTypes = new Class[args.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypes[i] = String.class;
                }
                Constructor c = objClass.getConstructor(paramTypes);
                ret = c.newInstance(args);
            } else {
                ret = objClass.newInstance();
            }
        }
        catch (NoSuchMethodException nme) {
            try {
                Constructor c = objClass.getConstructor(String[].class);
                Object[] wrappedArgs = new Object[]{args};
                ret = c.newInstance(wrappedArgs);
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("could not instantiate '");
                sb.append(className);
                sb.append("' with arguments '");
                sb.append(Arrays.toString(args));
                sb.append("'");
                throw new RuntimeException(sb.toString(), e);
            }
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("could not instantiate '");
            sb.append(className);
            sb.append("' with arguments '");
            sb.append(Arrays.toString(args));
            sb.append("'");
            throw new RuntimeException(sb.toString(), e);
        }
        return ret;
    }

    public static Object instantiateFuncFromSpec(String funcSpec) {
        return PigContext.instantiateFuncFromSpec(new FuncSpec(funcSpec));
    }

    public Class getClassForAlias(String alias) throws IOException {
        String className = null;
        FuncSpec funcSpec = null;
        if (this.definedFunctions != null) {
            funcSpec = this.definedFunctions.get(alias);
        }
        className = funcSpec != null ? funcSpec.getClassName() : FuncSpec.getClassNameFromSpec(alias);
        return PigContext.resolveClassName(className);
    }

    public Object instantiateFuncFromAlias(String alias) throws IOException {
        FuncSpec funcSpec;
        if (this.definedFunctions != null && (funcSpec = this.definedFunctions.get(alias)) != null) {
            return PigContext.instantiateFuncFromSpec(funcSpec);
        }
        return PigContext.instantiateFuncFromSpec(alias);
    }

    public StreamingCommand getCommandForAlias(String alias) {
        return this.definedCommands.get(alias);
    }

    public void setExecType(ExecType execType) {
        this.execType = execType;
    }

    public ExecutableManager createExecutableManager() throws ExecException {
        if (this.executionEngine != null) {
            return this.executionEngine.getExecutableManager();
        }
        return null;
    }

    public FuncSpec getFuncSpecFromAlias(String alias) {
        FuncSpec funcSpec;
        if (this.definedFunctions != null && (funcSpec = this.definedFunctions.get(alias)) != null) {
            return funcSpec;
        }
        return null;
    }

    public void addPathToSkip(String path) {
        this.skippedShipPaths.add(path);
    }

    public List<String> getPathsToSkip() {
        return this.skippedShipPaths;
    }

    public byte getErrorSource() {
        return 16;
    }

    public static ArrayList<String> getPackageImportList() {
        if (packageImportList.get() == null) {
            ArrayList<String> importlist = new ArrayList<String>();
            importlist.add("");
            importlist.add("java.lang.");
            importlist.add("org.apache.pig.builtin.");
            importlist.add("org.apache.pig.impl.builtin.");
            packageImportList.set(importlist);
        }
        return packageImportList.get();
    }

    public static void setPackageImportList(ArrayList<String> list) {
        packageImportList.set(list);
    }

    public void setLog4jProperties(Properties p) {
        this.log4jProperties = p;
    }

    public Properties getLog4jProperties() {
        return this.log4jProperties;
    }

    public Level getDefaultLogLevel() {
        return this.defaultLogLevel;
    }

    public void setDefaultLogLevel(Level l) {
        this.defaultLogLevel = l;
    }

    public static ClassLoader getClassLoader() {
        return classloader;
    }

    public static void setClassLoader(ClassLoader cl) {
        classloader = cl instanceof ContextClassLoader ? (ContextClassLoader)cl : new ContextClassLoader(cl);
    }

    static {
        JVMReuseManager.getInstance().registerForStaticDataCleanup(PigContext.class);
        classloader = new ContextClassLoader(PigContext.class.getClassLoader());
    }

    private static class ContextClassLoader
    extends URLClassLoader {
        public ContextClassLoader(ClassLoader classLoader) {
            this(new URL[0], classLoader);
        }

        public ContextClassLoader(URL[] urls, ClassLoader classLoader) {
            super(urls, classLoader);
        }

        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

