/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFCross
extends EvalFunc<DataBag> {
    private int numInputs;
    private int myNumber;
    private int numGroupsPerInput;
    private int numGroupsGoingTo;
    private BagFactory mBagFactory = BagFactory.getInstance();
    private TupleFactory mTupleFactory = TupleFactory.getInstance();
    private int parallelism = 0;
    private Random r = new Random();
    private String crossKey;
    private static final int DEFAULT_PARALLELISM = 96;

    public GFCross(String key) {
        this.crossKey = key;
    }

    public String getCrossKey() {
        return this.crossKey;
    }

    @Override
    public DataBag exec(Tuple input) throws IOException {
        if (this.parallelism == 0) {
            this.parallelism = 96;
            Configuration cfg = UDFContext.getUDFContext().getJobConf();
            if (cfg != null) {
                String s = cfg.get("pig.cross.parallelism." + this.crossKey);
                if (s == null) {
                    throw new IOException("Unable to get parallelism hint from job conf");
                }
                this.parallelism = Integer.valueOf(s);
                if (this.parallelism < 0) {
                    throw new IOException("pig.cross.parallelism." + this.crossKey + " was " + this.parallelism);
                }
            }
            this.numInputs = (Integer)input.get(0);
            this.myNumber = (Integer)input.get(1);
            this.numGroupsPerInput = (int)Math.ceil(Math.pow(this.parallelism, 1.0 / (double)this.numInputs));
            this.numGroupsGoingTo = (int)Math.pow(this.numGroupsPerInput, this.numInputs - 1);
        }
        DataBag output = this.mBagFactory.newDefaultBag();
        int[] digits = new int[this.numInputs];
        digits[this.myNumber] = this.r.nextInt(this.numGroupsPerInput);
        for (int i = 0; i < this.numGroupsGoingTo; ++i) {
            output.add(this.toTuple(digits));
            this.next(digits);
        }
        return output;
    }

    private Tuple toTuple(int[] digits) throws IOException, ExecException {
        Tuple t = this.mTupleFactory.newTuple(this.numInputs);
        for (int i = 0; i < this.numInputs; ++i) {
            t.set(i, digits[i]);
        }
        return t;
    }

    private void next(int[] digits) {
        for (int i = 0; i < this.numInputs; ++i) {
            if (i == this.myNumber) continue;
            if (digits[i] == this.numGroupsPerInput - 1) {
                digits[i] = 0;
                continue;
            }
            int n = i;
            digits[n] = digits[n] + 1;
            break;
        }
    }
}

