/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.util.GroupingSpillable;
import org.apache.pig.impl.util.Spillable;

public class SpillableMemoryManager
implements NotificationListener {
    private final Log log = LogFactory.getLog(this.getClass());
    LinkedList<WeakReference<Spillable>> spillables = new LinkedList();
    private static long gcActivationSize = 40000000L;
    private static long spillFileSizeThreshold = 5000000L;
    private static long accumulatedFreeSize = 0L;
    private static double memoryThresholdFraction = 0.7;
    private static double collectionMemoryThresholdFraction = 0.5;
    private boolean firstUsageThreshExceededLogged = false;
    private boolean firstCollectionThreshExceededLogged = false;
    private static double extraGCThresholdFraction = 0.05;
    private static long extraGCSpillSizeThreshold = 0L;
    private static volatile SpillableMemoryManager manager;

    private SpillableMemoryManager() {
        ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this, null, null);
        List<MemoryPoolMXBean> mpbeans = ManagementFactory.getMemoryPoolMXBeans();
        MemoryPoolMXBean tenuredHeap = null;
        long tenuredHeapSize = 0L;
        long totalSize = 0L;
        for (MemoryPoolMXBean pool : mpbeans) {
            this.log.debug((Object)("Found heap (" + pool.getName() + ") of type " + (Object)((Object)pool.getType())));
            if (pool.getType() != MemoryType.HEAP) continue;
            long size = pool.getUsage().getMax();
            totalSize += size;
            if (!pool.isUsageThresholdSupported()) continue;
            tenuredHeapSize = size;
            tenuredHeap = pool;
        }
        extraGCSpillSizeThreshold = (long)((double)totalSize * extraGCThresholdFraction);
        if (tenuredHeap == null) {
            throw new RuntimeException("Couldn't find heap");
        }
        this.log.debug((Object)("Selected heap to monitor (" + tenuredHeap.getName() + ")"));
        tenuredHeap.setCollectionUsageThreshold((long)((double)tenuredHeapSize * collectionMemoryThresholdFraction));
        tenuredHeap.setUsageThreshold((long)((double)tenuredHeapSize * memoryThresholdFraction));
    }

    public static SpillableMemoryManager getInstance() {
        if (manager == null) {
            manager = new SpillableMemoryManager();
        }
        return manager;
    }

    public static void configure(Properties properties) {
        try {
            spillFileSizeThreshold = Long.parseLong(properties.getProperty("pig.spill.size.threshold"));
            gcActivationSize = Long.parseLong(properties.getProperty("pig.spill.gc.activation.size"));
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Error while converting system configurationsspill.size.threshold, spill.gc.activation.size", nfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification n, Object o) {
        String msg;
        long threshold;
        CompositeData cd = (CompositeData)n.getUserData();
        MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
        long toFree = 0L;
        if (n.getType().equals("java.management.memory.threshold.exceeded")) {
            threshold = (long)((double)info.getUsage().getMax() * memoryThresholdFraction);
            toFree = info.getUsage().getUsed() - threshold + (long)((double)threshold * 0.5);
            msg = "memory handler call- Usage threshold " + info.getUsage();
            if (!this.firstUsageThreshExceededLogged) {
                this.log.info((Object)("first " + msg));
                this.firstUsageThreshExceededLogged = true;
            } else {
                this.log.debug((Object)msg);
            }
        } else {
            threshold = (long)((double)info.getUsage().getMax() * collectionMemoryThresholdFraction);
            toFree = info.getUsage().getUsed() - threshold + (long)((double)threshold * 0.5);
            msg = "memory handler call - Collection threshold " + info.getUsage();
            if (!this.firstCollectionThreshExceededLogged) {
                this.log.info((Object)("first " + msg));
                this.firstCollectionThreshExceededLogged = true;
            } else {
                this.log.debug((Object)msg);
            }
        }
        this.clearSpillables();
        if (toFree < 0L) {
            this.log.debug((Object)"low memory handler returning because there is nothing to free");
            return;
        }
        LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
        synchronized (linkedList) {
            Collections.sort(this.spillables, new Comparator<WeakReference<Spillable>>(){

                @Override
                public int compare(WeakReference<Spillable> o1Ref, WeakReference<Spillable> o2Ref) {
                    long o2Size;
                    Spillable o1 = (Spillable)o1Ref.get();
                    Spillable o2 = (Spillable)o2Ref.get();
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    long o1Size = o1.getMemorySize();
                    if (o1Size == (o2Size = o2.getMemorySize())) {
                        return 0;
                    }
                    if (o1Size < o2Size) {
                        return 1;
                    }
                    return -1;
                }
            });
            long estimatedFreed = 0L;
            int numObjSpilled = 0;
            boolean invokeGC = false;
            boolean extraGCCalled = false;
            Iterator i = this.spillables.iterator();
            while (i.hasNext()) {
                WeakReference weakRef = (WeakReference)i.next();
                Spillable s = (Spillable)weakRef.get();
                if (s == null) {
                    i.remove();
                    continue;
                }
                long toBeFreed = s.getMemorySize();
                this.log.debug((Object)("Memorysize = " + toBeFreed + ", spillFilesizethreshold = " + spillFileSizeThreshold + ", gcactivationsize = " + gcActivationSize));
                if (toBeFreed < spillFileSizeThreshold) {
                    this.log.debug((Object)"spilling small files - getting out of memory handler");
                    break;
                }
                if (!extraGCCalled && extraGCSpillSizeThreshold != 0L && toBeFreed > extraGCSpillSizeThreshold && !(s instanceof GroupingSpillable)) {
                    this.log.debug((Object)("Single spillable has size " + toBeFreed + "bytes. Calling extra gc()"));
                    s = null;
                    System.gc();
                    extraGCCalled = true;
                    s = (Spillable)weakRef.get();
                    if (s == null) {
                        i.remove();
                        accumulatedFreeSize = 0L;
                        invokeGC = false;
                        continue;
                    }
                }
                s.spill();
                ++numObjSpilled;
                estimatedFreed += toBeFreed;
                if ((accumulatedFreeSize += toBeFreed) > gcActivationSize) {
                    invokeGC = true;
                }
                if (estimatedFreed <= toFree) continue;
                this.log.debug((Object)"Freed enough space - getting out of memory handler");
                invokeGC = true;
                break;
            }
            if (invokeGC) {
                System.gc();
                accumulatedFreeSize = 0L;
            }
            if (estimatedFreed > 0L) {
                String msg2 = "Spilled an estimate of " + estimatedFreed + " bytes from " + numObjSpilled + " objects. " + info.getUsage();
                this.log.info((Object)msg2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSpillables() {
        LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
        synchronized (linkedList) {
            Iterator i = this.spillables.iterator();
            while (i.hasNext()) {
                Spillable s = (Spillable)((WeakReference)i.next()).get();
                if (s != null) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSpillable(Spillable s) {
        LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
        synchronized (linkedList) {
            WeakReference<Spillable> first = this.spillables.peek();
            while (first != null && first.get() == null) {
                this.spillables.remove();
                first = this.spillables.peek();
            }
            this.spillables.add(new WeakReference<Spillable>(s));
        }
    }
}

