/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.orc;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.tools.pigstats.PigStatusReporter;
import org.joda.time.DateTime;

public class OrcUtils {
    public static Object convertOrcToPig(Object obj, ObjectInspector oi, boolean[] includedColumns) {
        Serializable result = null;
        if (obj == null) {
            return result;
        }
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                result = OrcUtils.getPrimaryFromOrc(obj, poi);
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List elementFields = soi.getAllStructFieldRefs();
                List items = soi.getStructFieldsDataAsList(obj);
                Tuple t = TupleFactory.getInstance().newTuple();
                for (int i = 0; i < items.size(); ++i) {
                    if (includedColumns != null && !includedColumns[i]) continue;
                    Object convertedItem = OrcUtils.convertOrcToPig(items.get(i), ((StructField)elementFields.get(i)).getFieldObjectInspector(), null);
                    t.append(convertedItem);
                }
                result = t;
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                ObjectInspector keyObjectInspector = moi.getMapKeyObjectInspector();
                ObjectInspector valueObjectInspector = moi.getMapValueObjectInspector();
                Map m = (Map)obj;
                result = new HashMap();
                for (Map.Entry entry : m.entrySet()) {
                    Object convertedKey = OrcUtils.convertOrcToPig(entry.getKey(), keyObjectInspector, null);
                    Object convertedValue = OrcUtils.convertOrcToPig(entry.getValue(), valueObjectInspector, null);
                    if (convertedKey != null) {
                        ((Map)((Object)result)).put(convertedKey.toString(), convertedValue);
                        continue;
                    }
                    PigStatusReporter reporter = PigStatusReporter.getInstance();
                    if (reporter == null) continue;
                    reporter.incrCounter(PigWarning.UDF_WARNING_1, 1L);
                }
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                result = BagFactory.getInstance().newDefaultBag();
                ObjectInspector itemObjectInspector = loi.getListElementObjectInspector();
                for (Object item : loi.getList(obj)) {
                    Tuple convertedItem = (Tuple)OrcUtils.convertOrcToPig(item, itemObjectInspector, null);
                    ((DataBag)result).add(convertedItem);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + oi.getCategory());
            }
        }
        return result;
    }

    public static Object getPrimaryFromOrc(Object obj, PrimitiveObjectInspector poi) {
        Object result = null;
        if (obj == null) {
            return result;
        }
        switch (poi.getPrimitiveCategory()) {
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case STRING: {
                result = poi.getPrimitiveJavaObject(obj);
                break;
            }
            case CHAR: {
                result = ((HiveChar)poi.getPrimitiveJavaObject(obj)).getValue();
                break;
            }
            case VARCHAR: {
                result = ((HiveVarchar)poi.getPrimitiveJavaObject(obj)).getValue();
                break;
            }
            case BYTE: {
                result = (int)((Byte)poi.getPrimitiveJavaObject(obj)).byteValue();
                break;
            }
            case SHORT: {
                result = (int)((Short)poi.getPrimitiveJavaObject(obj)).shortValue();
                break;
            }
            case BINARY: {
                BytesWritable bw = (BytesWritable)obj;
                result = new DataByteArray(bw.getBytes(), 0, bw.getLength());
                break;
            }
            case TIMESTAMP: {
                Timestamp origTimeStamp = (Timestamp)poi.getPrimitiveJavaObject(obj);
                result = new DateTime(origTimeStamp.getTime());
                break;
            }
            case DATE: {
                Date origDate = (Date)poi.getPrimitiveJavaObject(obj);
                result = new DateTime(origDate.getTime());
                break;
            }
            case DECIMAL: {
                HiveDecimal origDecimal = (HiveDecimal)poi.getPrimitiveJavaObject(obj);
                result = origDecimal.bigDecimalValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive type " + poi.getPrimitiveCategory());
            }
        }
        return result;
    }

    public static ResourceSchema.ResourceFieldSchema getResourceFieldSchema(TypeInfo ti) throws IOException {
        ResourceSchema.ResourceFieldSchema fieldSchema = new ResourceSchema.ResourceFieldSchema();
        block0 : switch (ti.getCategory()) {
            case STRUCT: {
                StructTypeInfo sti = (StructTypeInfo)ti;
                fieldSchema.setType((byte)110);
                ArrayList typeInfos = sti.getAllStructFieldTypeInfos();
                ArrayList names = sti.getAllStructFieldNames();
                ResourceSchema.ResourceFieldSchema[] innerFs = new ResourceSchema.ResourceFieldSchema[typeInfos.size()];
                for (int i = 0; i < typeInfos.size(); ++i) {
                    innerFs[i] = OrcUtils.getResourceFieldSchema((TypeInfo)typeInfos.get(i));
                    innerFs[i].setName((String)names.get(i));
                }
                ResourceSchema innerSchema = new ResourceSchema();
                innerSchema.setFields(innerFs);
                fieldSchema.setSchema(innerSchema);
                break;
            }
            case LIST: {
                ListTypeInfo lti = (ListTypeInfo)ti;
                fieldSchema.setType((byte)120);
                ResourceSchema.ResourceFieldSchema[] innerFs = new ResourceSchema.ResourceFieldSchema[]{OrcUtils.getResourceFieldSchema(lti.getListElementTypeInfo())};
                ResourceSchema innerSchema = new ResourceSchema();
                innerSchema.setFields(innerFs);
                fieldSchema.setSchema(innerSchema);
                break;
            }
            case MAP: {
                MapTypeInfo mti = (MapTypeInfo)ti;
                fieldSchema.setType((byte)100);
                ResourceSchema.ResourceFieldSchema[] innerFs = new ResourceSchema.ResourceFieldSchema[]{OrcUtils.getResourceFieldSchema(mti.getMapValueTypeInfo())};
                ResourceSchema innerSchema = new ResourceSchema();
                innerSchema.setFields(innerFs);
                fieldSchema.setSchema(innerSchema);
                break;
            }
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)ti).getPrimitiveCategory()) {
                    case FLOAT: {
                        fieldSchema.setType((byte)20);
                        break block0;
                    }
                    case DOUBLE: {
                        fieldSchema.setType((byte)25);
                        break block0;
                    }
                    case BOOLEAN: {
                        fieldSchema.setType((byte)5);
                        break block0;
                    }
                    case BYTE: {
                        fieldSchema.setType((byte)10);
                        break block0;
                    }
                    case SHORT: {
                        fieldSchema.setType((byte)10);
                        break block0;
                    }
                    case INT: {
                        fieldSchema.setType((byte)10);
                        break block0;
                    }
                    case LONG: {
                        fieldSchema.setType((byte)15);
                        break block0;
                    }
                    case BINARY: {
                        fieldSchema.setType((byte)50);
                        break block0;
                    }
                    case STRING: {
                        fieldSchema.setType((byte)55);
                        break block0;
                    }
                    case VARCHAR: {
                        fieldSchema.setType((byte)55);
                        break block0;
                    }
                    case CHAR: {
                        fieldSchema.setType((byte)55);
                        break block0;
                    }
                    case TIMESTAMP: {
                        fieldSchema.setType((byte)30);
                        break block0;
                    }
                    case DATE: {
                        fieldSchema.setType((byte)30);
                        break block0;
                    }
                    case DECIMAL: {
                        fieldSchema.setType((byte)70);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type " + ((PrimitiveTypeInfo)ti).getPrimitiveCategory());
            }
        }
        return fieldSchema;
    }

    public static TypeInfo getTypeInfo(ResourceSchema.ResourceFieldSchema fs) throws IOException {
        PrimitiveTypeInfo ti;
        switch (fs.getType()) {
            case 110: {
                ti = new StructTypeInfo();
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
                for (ResourceSchema.ResourceFieldSchema subFs : fs.getSchema().getFields()) {
                    TypeInfo info = OrcUtils.getTypeInfo(subFs);
                    names.add(subFs.getName());
                    typeInfos.add(info);
                }
                ((StructTypeInfo)ti).setAllStructFieldNames(names);
                ((StructTypeInfo)ti).setAllStructFieldTypeInfos(typeInfos);
                break;
            }
            case 120: {
                ti = new ListTypeInfo();
                if (fs.getSchema() == null || fs.getSchema().getFields().length != 1) {
                    throw new IOException("Wrong bag inner schema");
                }
                TypeInfo elementField = OrcUtils.getTypeInfo(fs.getSchema().getFields()[0]);
                ((ListTypeInfo)ti).setListElementTypeInfo(elementField);
                break;
            }
            case 100: {
                ti = new MapTypeInfo();
                Object valueField = fs.getSchema() == null || fs.getSchema().getFields().length != 1 ? TypeInfoFactory.binaryTypeInfo : OrcUtils.getTypeInfo(fs.getSchema().getFields()[0]);
                ((MapTypeInfo)ti).setMapKeyTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo);
                ((MapTypeInfo)ti).setMapValueTypeInfo((TypeInfo)valueField);
                break;
            }
            case 5: {
                ti = TypeInfoFactory.booleanTypeInfo;
                break;
            }
            case 10: {
                ti = TypeInfoFactory.intTypeInfo;
                break;
            }
            case 15: {
                ti = TypeInfoFactory.longTypeInfo;
                break;
            }
            case 20: {
                ti = TypeInfoFactory.floatTypeInfo;
                break;
            }
            case 25: {
                ti = TypeInfoFactory.doubleTypeInfo;
                break;
            }
            case 55: {
                ti = TypeInfoFactory.stringTypeInfo;
                break;
            }
            case 30: {
                ti = TypeInfoFactory.timestampTypeInfo;
                break;
            }
            case 70: {
                ti = TypeInfoFactory.decimalTypeInfo;
                break;
            }
            case 65: {
                ti = TypeInfoFactory.decimalTypeInfo;
                break;
            }
            case 50: {
                ti = TypeInfoFactory.binaryTypeInfo;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data type " + DataType.findTypeName(fs.getType()));
            }
        }
        return ti;
    }

    public static ObjectInspector createObjectInspector(TypeInfo info) {
        switch (info.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)info).getPrimitiveCategory()) {
                    case FLOAT: {
                        return PrimitiveObjectInspectorFactory.javaFloatObjectInspector;
                    }
                    case DOUBLE: {
                        return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
                    }
                    case BOOLEAN: {
                        return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
                    }
                    case INT: {
                        return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
                    }
                    case LONG: {
                        return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
                    }
                    case STRING: {
                        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
                    }
                    case TIMESTAMP: {
                        return new PigJodaTimeStampObjectInspector();
                    }
                    case DECIMAL: {
                        return new PigDecimalObjectInspector();
                    }
                    case BINARY: {
                        return new PigDataByteArrayObjectInspector();
                    }
                    case VARCHAR: 
                    case BYTE: 
                    case SHORT: 
                    case DATE: {
                        throw new IllegalArgumentException("Should never happen, " + ((PrimitiveTypeInfo)info).getPrimitiveCategory() + "is not valid Pig primitive data type");
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type " + ((PrimitiveTypeInfo)info).getPrimitiveCategory());
            }
            case STRUCT: {
                return new PigStructInspector((StructTypeInfo)info);
            }
            case MAP: {
                return new PigMapObjectInspector((MapTypeInfo)info);
            }
            case LIST: {
                return new PigListObjectInspector((ListTypeInfo)info);
            }
        }
        throw new IllegalArgumentException("Unknown type " + info.getCategory());
    }

    static class PigDecimalObjectInspector
    extends AbstractPrimitiveJavaObjectInspector
    implements HiveDecimalObjectInspector {
        protected PigDecimalObjectInspector() {
            super((PrimitiveTypeInfo)TypeInfoFactory.decimalTypeInfo);
        }

        public HiveDecimalWritable getPrimitiveWritableObject(Object o) {
            if (o instanceof BigDecimal) {
                return o == null ? null : new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)o)));
            }
            return o == null ? null : new HiveDecimalWritable(HiveDecimal.create((BigInteger)((BigInteger)o)));
        }

        public HiveDecimal getPrimitiveJavaObject(Object o) {
            if (o instanceof BigDecimal) {
                return o == null ? null : HiveDecimal.create((BigDecimal)((BigDecimal)o));
            }
            return o == null ? null : HiveDecimal.create((BigInteger)((BigInteger)o));
        }
    }

    static class PigJodaTimeStampObjectInspector
    extends AbstractPrimitiveJavaObjectInspector
    implements TimestampObjectInspector {
        protected PigJodaTimeStampObjectInspector() {
            super(TypeInfoFactory.timestampTypeInfo);
        }

        public TimestampWritable getPrimitiveWritableObject(Object o) {
            return o == null ? null : new TimestampWritable(new Timestamp(((DateTime)o).getMillis()));
        }

        public Timestamp getPrimitiveJavaObject(Object o) {
            return o == null ? null : new Timestamp(((DateTime)o).getMillis());
        }
    }

    static class PigDataByteArrayObjectInspector
    extends AbstractPrimitiveJavaObjectInspector
    implements BinaryObjectInspector {
        PigDataByteArrayObjectInspector() {
            super(TypeInfoFactory.binaryTypeInfo);
        }

        public BytesWritable getPrimitiveWritableObject(Object o) {
            return o == null ? null : (o instanceof DataByteArray ? new BytesWritable(((DataByteArray)o).get()) : new BytesWritable((byte[])o));
        }

        public byte[] getPrimitiveJavaObject(Object o) {
            return ((DataByteArray)o).get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PigListObjectInspector
    implements ListObjectInspector {
        private ObjectInspector child;
        private Object cachedObject;
        private int index;
        private Iterator<Tuple> iter;

        PigListObjectInspector(ListTypeInfo info) {
            this.child = OrcUtils.createObjectInspector(info.getListElementTypeInfo());
        }

        public ObjectInspector getListElementObjectInspector() {
            return this.child;
        }

        public Object getListElement(Object list, int i) {
            if (list != this.cachedObject) {
                this.cachedObject = list;
                this.index = -1;
                DataBag db = (DataBag)list;
                this.iter = db.iterator();
            }
            if (i == this.index + 1) {
                ++this.index;
                return this.iter.next();
            }
            throw new RuntimeException("Only sequential read is supported");
        }

        public int getListLength(Object list) {
            return (int)((DataBag)list).size();
        }

        public List<?> getList(Object list) {
            ArrayList<Tuple> result = new ArrayList<Tuple>();
            DataBag bag = (DataBag)list;
            for (Tuple t : bag) {
                result.add(t);
            }
            return result;
        }

        public String getTypeName() {
            return "array<" + this.child.getTypeName() + ">";
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.LIST;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ObjectInspector other = ((PigListObjectInspector)o).child;
            return other.equals(this.child);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PigMapObjectInspector
    implements MapObjectInspector {
        private ObjectInspector key;
        private ObjectInspector value;

        PigMapObjectInspector(MapTypeInfo info) {
            this.key = OrcUtils.createObjectInspector(info.getMapKeyTypeInfo());
            this.value = OrcUtils.createObjectInspector(info.getMapValueTypeInfo());
        }

        public ObjectInspector getMapKeyObjectInspector() {
            return this.key;
        }

        public ObjectInspector getMapValueObjectInspector() {
            return this.value;
        }

        public Object getMapValueElement(Object map, Object key) {
            return ((Map)map).get(key);
        }

        public Map<Object, Object> getMap(Object map) {
            return (Map)map;
        }

        public int getMapSize(Object map) {
            return ((Map)map).size();
        }

        public String getTypeName() {
            return "map<" + this.key.getTypeName() + "," + this.value.getTypeName() + ">";
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.MAP;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            PigMapObjectInspector other = (PigMapObjectInspector)o;
            return other.key.equals(this.key) && other.value.equals(this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PigStructInspector
    extends StructObjectInspector {
        private List<StructField> fields;

        PigStructInspector(StructTypeInfo info) {
            ArrayList fieldNames = info.getAllStructFieldNames();
            ArrayList fieldTypes = info.getAllStructFieldTypeInfos();
            this.fields = new ArrayList<StructField>(fieldNames.size());
            for (int i = 0; i < fieldNames.size(); ++i) {
                this.fields.add(new Field((String)fieldNames.get(i), OrcUtils.createObjectInspector((TypeInfo)fieldTypes.get(i)), i));
            }
        }

        public List<StructField> getAllStructFieldRefs() {
            return this.fields;
        }

        public StructField getStructFieldRef(String s) {
            for (StructField field : this.fields) {
                if (!field.getFieldName().equals(s)) continue;
                return field;
            }
            return null;
        }

        public Object getStructFieldData(Object object, StructField field) {
            Object result = null;
            try {
                result = ((Tuple)object).get(((Field)field).offset);
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public List<Object> getStructFieldsDataAsList(Object object) {
            return ((Tuple)object).getAll();
        }

        public String getTypeName() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("struct<");
            for (int i = 0; i < this.fields.size(); ++i) {
                StructField field = this.fields.get(i);
                if (i != 0) {
                    buffer.append(",");
                }
                buffer.append(field.getFieldName());
                buffer.append(":");
                buffer.append(field.getFieldObjectInspector().getTypeName());
            }
            buffer.append(">");
            return buffer.toString();
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.STRUCT;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            List<StructField> other = ((PigStructInspector)((Object)o)).fields;
            if (other.size() != this.fields.size()) {
                return false;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                StructField left = other.get(i);
                StructField right = this.fields.get(i);
                if (left.getFieldName().equals(right.getFieldName()) && left.getFieldObjectInspector().equals(right.getFieldObjectInspector())) continue;
                return false;
            }
            return true;
        }
    }

    static class Field
    implements StructField {
        private final String name;
        private final ObjectInspector inspector;
        private final int offset;

        Field(String name, ObjectInspector inspector, int offset) {
            this.name = name;
            this.inspector = inspector;
            this.offset = offset;
        }

        public String getFieldName() {
            return this.name;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        public int getFieldID() {
            return this.offset;
        }

        public String getFieldComment() {
            return null;
        }
    }
}

