/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadPredicatePushdown;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.PredicatePushDownFilterExtractor;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class PredicatePushdownOptimizer
extends Rule {
    public PredicatePushdownOptimizer(String name) {
        super(name, false);
    }

    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOLoad load = new LOLoad(null, plan);
        plan.add(load);
        return plan;
    }

    public Transformer getNewTransformer() {
        return new PredicatePushDownTransformer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PredicatePushDownTransformer
    extends Transformer {
        private LOLoad loLoad;
        private LOFilter loFilter;
        private LoadFunc loadFunc;
        private LoadPredicatePushdown loadPredPushdown;
        private List<String> predicateFields;
        private Map<String, String> colNameMap = new HashMap<String, String>();
        private Map<String, String> reverseColNameMap = new HashMap<String, String>();
        private OperatorSubPlan subPlan;
        private boolean planChanged;

        PredicatePushDownTransformer() {
        }

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            this.loLoad = (LOLoad)matched.getSources().get(0);
            List<Operator> succeds = PredicatePushdownOptimizer.this.currentPlan.getSuccessors(this.loLoad);
            if (succeds == null || succeds.size() == 0 || !(succeds.get(0) instanceof LOFilter)) {
                return false;
            }
            this.loFilter = (LOFilter)succeds.get(0);
            if (PredicatePushdownOptimizer.this.currentPlan.getSoftLinkPredecessors(this.loFilter) != null) {
                return false;
            }
            this.loadFunc = this.loLoad.getLoadFunc();
            if (!(this.loadFunc instanceof LoadPredicatePushdown)) {
                return false;
            }
            this.loadPredPushdown = (LoadPredicatePushdown)((Object)this.loadFunc);
            try {
                this.predicateFields = this.loadPredPushdown.getPredicateFields(this.loLoad.getFileSpec().getFileName(), new Job(this.loLoad.getConfiguration()));
            }
            catch (IOException e) {
                throw new FrontendException(e);
            }
            return this.predicateFields != null && this.predicateFields.size() != 0;
        }

        @Override
        public OperatorPlan reportChanges() {
            return this.planChanged ? this.subPlan : null;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            this.subPlan = new OperatorSubPlan(PredicatePushdownOptimizer.this.currentPlan);
            this.setupColNameMaps();
            PredicatePushDownFilterExtractor filterFinder = new PredicatePushDownFilterExtractor(this.loFilter.getFilterPlan(), this.getMappedKeys(this.predicateFields), this.loadPredPushdown.getSupportedExpressionTypes());
            filterFinder.visit();
            Expression pushDownPredicate = filterFinder.getPushDownExpression();
            if (pushDownPredicate != null) {
                this.updateMappedColNames(pushDownPredicate);
                try {
                    this.loadPredPushdown.setPushdownPredicate(pushDownPredicate);
                }
                catch (IOException e) {
                    throw new FrontendException(e);
                }
            }
        }

        protected void updateMappedColNames(Expression expr) {
            if (expr instanceof Expression.BinaryExpression) {
                this.updateMappedColNames(((Expression.BinaryExpression)expr).getLhs());
                this.updateMappedColNames(((Expression.BinaryExpression)expr).getRhs());
            } else if (expr instanceof Expression.Column) {
                Expression.Column col = (Expression.Column)expr;
                col.setName(this.reverseColNameMap.get(col.getName()));
            }
        }

        protected List<String> getMappedKeys(List<String> predicateFields) {
            ArrayList<String> mappedKeys = new ArrayList<String>(predicateFields.size());
            for (int i = 0; i < predicateFields.size(); ++i) {
                mappedKeys.add(this.colNameMap.get(predicateFields.get(i)));
            }
            return mappedKeys;
        }

        protected void setupColNameMaps() throws FrontendException {
            LogicalSchema loLoadSchema = this.loLoad.getSchema();
            LogicalSchema loadFuncSchema = this.loLoad.getDeterminedSchema();
            for (int i = 0; i < loadFuncSchema.size(); ++i) {
                this.colNameMap.put(loadFuncSchema.getField((int)i).alias, i < loLoadSchema.size() ? loLoadSchema.getField((int)i).alias : loadFuncSchema.getField((int)i).alias);
                this.reverseColNameMap.put(i < loLoadSchema.size() ? loLoadSchema.getField((int)i).alias : loadFuncSchema.getField((int)i).alias, loadFuncSchema.getField((int)i).alias);
            }
        }
    }
}

