/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.optimizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.optimizer.PlanTransformListener;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlanOptimizer {
    protected List<Set<Rule>> ruleSets;
    protected OperatorPlan plan;
    protected List<PlanTransformListener> listeners;
    protected int maxIter;
    static final int defaultIterations = 500;

    protected PlanOptimizer(OperatorPlan p, List<Set<Rule>> rs, int iterations) {
        this.plan = p;
        this.ruleSets = rs;
        this.listeners = new ArrayList<PlanTransformListener>();
        this.maxIter = iterations < 1 ? 500 : iterations;
    }

    protected void addPlanTransformListener(PlanTransformListener listener) {
        this.listeners.add(listener);
    }

    public void optimize() throws FrontendException {
        for (Set<Rule> rs : this.ruleSets) {
            boolean sawMatch = false;
            int numIterations = 0;
            do {
                sawMatch = false;
                for (Rule rule : rs) {
                    List<OperatorPlan> matches = rule.match(this.plan);
                    if (matches == null) continue;
                    Transformer transformer = rule.getNewTransformer();
                    for (OperatorPlan m : matches) {
                        try {
                            if (!transformer.check(m)) continue;
                            sawMatch = true;
                            transformer.transform(m);
                            OperatorPlan change = transformer.reportChanges();
                            if (change == null) {
                                sawMatch = false;
                                continue;
                            }
                            if (rule.isSkipListener()) continue;
                            for (PlanTransformListener l : this.listeners) {
                                l.transformed(this.plan, change);
                            }
                        }
                        catch (Exception e) {
                            StringBuffer message = new StringBuffer("Error processing rule " + rule.name);
                            if (!rule.isMandatory()) {
                                message.append(". Try -t " + rule.name);
                            }
                            throw new FrontendException(message.toString(), 2000, e);
                        }
                    }
                }
            } while (sawMatch && ++numIterations < this.maxIter);
        }
    }
}

