/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.streaming.python;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.PigContext;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.tools.pigstats.PigStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonScriptEngine
extends ScriptEngine {
    private static final Log log = LogFactory.getLog(PythonScriptEngine.class);
    private static final Pattern pSchema = Pattern.compile("^\\s*\\W+outputSchema.*");
    private static final Pattern pDef = Pattern.compile("^\\s*def\\s+(\\w+)\\s*.+");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFunctions(String path, String namespace, PigContext pigContext) throws IOException {
        String command = pigContext.getProperties().getProperty("pig.streaming.udf.python.command", "python");
        String fileName = path.substring(0, path.length() - ".py".length());
        log.debug((Object)("Path: " + path + " FileName: " + fileName + " Namespace: " + namespace));
        File f = new File(path);
        if (!f.canRead()) {
            throw new IOException("Can't read file: " + path);
        }
        FileInputStream fin = new FileInputStream(f);
        List<String[]> functions = null;
        try {
            functions = PythonScriptEngine.getFunctions(fin);
        }
        finally {
            fin.close();
        }
        namespace = namespace == null ? "" : namespace + ".";
        for (String[] functionInfo : functions) {
            String name = functionInfo[0];
            String schemaString = functionInfo[1];
            String schemaLineNumber = functionInfo[2];
            String alias = namespace + name;
            String execType = pigContext.getExecType() == ExecType.LOCAL ? "local" : "mapreduce";
            String isIllustrate = Boolean.valueOf(pigContext.inIllustrator).toString();
            log.debug((Object)("Registering Function: " + alias));
            pigContext.registerFunction(alias, new FuncSpec("StreamingUDF", new String[]{command, fileName, name, schemaString, schemaLineNumber, execType, isIllustrate}));
        }
    }

    @Override
    protected Map<String, List<PigStats>> main(PigContext context, String scriptFile) throws IOException {
        log.warn((Object)("ScriptFile: " + scriptFile));
        this.registerFunctions(scriptFile, null, context);
        return this.getPigStatsMap();
    }

    @Override
    protected String getScriptingLang() {
        return "streaming_python";
    }

    @Override
    protected Map<String, Object> getParamsFromVariables() throws IOException {
        throw new IOException("Unsupported Operation");
    }

    private static List<String[]> getFunctions(InputStream is) throws IOException {
        ArrayList<String[]> functions = new ArrayList<String[]>();
        InputStreamReader in = new InputStreamReader(is, Charset.defaultCharset());
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        String schemaString = null;
        String schemaLineNumber = null;
        int lineNumber = 1;
        while (line != null) {
            int end;
            int start;
            if (pSchema.matcher(line).matches()) {
                start = line.indexOf("(") + 2;
                end = line.lastIndexOf(")") - 1;
                schemaString = line.substring(start, end).trim();
                schemaLineNumber = "" + lineNumber;
            } else if (pDef.matcher(line).matches()) {
                start = line.indexOf("def ") + "def ".length();
                end = line.indexOf(40);
                String functionName = line.substring(start, end).trim();
                if (schemaString != null) {
                    String[] funcInfo = new String[]{functionName, schemaString, "" + schemaLineNumber};
                    functions.add(funcInfo);
                    schemaString = null;
                }
            }
            line = br.readLine();
            ++lineNumber;
        }
        return functions;
    }
}

