/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.FileBasedOutputSizeReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigStatsOutputSizeReader;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.ScriptState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class JobStats
extends Operator {
    private static final Log LOG = LogFactory.getLog(JobStats.class);
    public static final String ALIAS = "JobStatistics:alias";
    public static final String ALIAS_LOCATION = "JobStatistics:alias_location";
    public static final String FEATURE = "JobStatistics:feature";
    public static final String SUCCESS_HEADER = null;
    public static final String FAILURE_HEADER = null;
    protected JobState state = JobState.UNKNOWN;
    protected ArrayList<OutputStats> outputs = new ArrayList();
    protected ArrayList<InputStats> inputs = new ArrayList();
    protected Configuration conf;
    protected long hdfsBytesRead = 0L;
    protected long hdfsBytesWritten = 0L;
    private String errorMsg;
    private Exception exception = null;

    protected JobStats(String name, PigStats.JobGraph plan) {
        super(name, plan);
    }

    public abstract String getJobId();

    public void setConf(Configuration conf) {
        if (conf == null) {
            return;
        }
        this.conf = conf;
    }

    public JobState getState() {
        return this.state;
    }

    public boolean isSuccessful() {
        return this.state == JobState.SUCCESS;
    }

    public void setSuccessful(boolean isSuccessful) {
        this.state = isSuccessful ? JobState.SUCCESS : JobState.FAILED;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public Exception getException() {
        return this.exception;
    }

    public List<OutputStats> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    public List<InputStats> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    public String getAlias() {
        return (String)this.getAnnotation(ALIAS);
    }

    public String getAliasLocation() {
        return (String)this.getAnnotation(ALIAS_LOCATION);
    }

    public String getFeature() {
        return (String)this.getAnnotation(FEATURE);
    }

    public long getHdfsBytesRead() {
        return this.hdfsBytesRead;
    }

    public long getHdfsBytesWritten() {
        return this.hdfsBytesWritten;
    }

    public long getBytesWritten() {
        long count = 0L;
        for (OutputStats out : this.outputs) {
            long n = out.getBytes();
            if (n <= 0L) continue;
            count += n;
        }
        return count;
    }

    public long getRecordWrittern() {
        long count = 0L;
        for (OutputStats out : this.outputs) {
            long rec = out.getNumberRecords();
            if (rec <= 0L) continue;
            count += rec;
        }
        return count;
    }

    @Override
    public abstract void accept(PlanVisitor var1) throws FrontendException;

    @Override
    public boolean isEqual(Operator operator) {
        if (!(operator instanceof JobStats)) {
            return false;
        }
        return this.name.equalsIgnoreCase(operator.getName());
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setBackendException(Exception e) {
        this.exception = e;
    }

    public abstract String getDisplayString();

    protected long calculateMedianValue(List<Long> durations) {
        Collections.sort(durations);
        int midPoint = durations.size() / 2;
        long median = (durations.size() & 1) == 1 ? durations.get(midPoint) : (durations.get(midPoint - 1) + durations.get(midPoint)) / 2L;
        return median;
    }

    public boolean isSampler() {
        return this.getFeature().contains(ScriptState.PIG_FEATURE.SAMPLER.name());
    }

    public boolean isIndexer() {
        return this.getFeature().contains(ScriptState.PIG_FEATURE.INDEXER.name());
    }

    @Deprecated
    public abstract int getNumberMaps();

    @Deprecated
    public abstract int getNumberReduces();

    @Deprecated
    public abstract long getMaxMapTime();

    @Deprecated
    public abstract long getMinMapTime();

    @Deprecated
    public abstract long getAvgMapTime();

    @Deprecated
    public abstract long getMaxReduceTime();

    @Deprecated
    public abstract long getMinReduceTime();

    @Deprecated
    public abstract long getAvgREduceTime();

    @Deprecated
    public abstract long getMapInputRecords();

    @Deprecated
    public abstract long getMapOutputRecords();

    @Deprecated
    public abstract long getReduceInputRecords();

    @Deprecated
    public abstract long getReduceOutputRecords();

    @Deprecated
    public abstract long getSMMSpillCount();

    @Deprecated
    public abstract long getProactiveSpillCountObjects();

    @Deprecated
    public abstract long getProactiveSpillCountRecs();

    @Deprecated
    public abstract Counters getHadoopCounters();

    @Deprecated
    public abstract Map<String, Long> getMultiStoreCounters();

    @Deprecated
    public abstract Map<String, Long> getMultiInputCounters();

    public static long getOutputSize(POStore sto, Configuration conf) {
        PigStatsOutputSizeReader reader = null;
        String readerNames = conf.get("pig.stats.output.size.reader", FileBasedOutputSizeReader.class.getCanonicalName());
        for (String className : readerNames.split(",")) {
            reader = (PigStatsOutputSizeReader)PigContext.instantiateFuncFromSpec(className);
            if (!reader.supports(sto, conf)) continue;
            LOG.info((Object)("using output size reader: " + className));
            try {
                return reader.getOutputSize(sto, conf);
            }
            catch (FileNotFoundException e) {
                LOG.warn((Object)"unable to find the output file", (Throwable)e);
                return -1L;
            }
            catch (IOException e) {
                LOG.warn((Object)"unable to get byte written of the job", (Throwable)e);
                return -1L;
            }
        }
        LOG.warn((Object)"unable to find an output size reader");
        return -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobState {
        UNKNOWN,
        SUCCESS,
        FAILED;

    }
}

