/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.pdi;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.platform.api.engine.IPlatformWebResource;

public class WebContextServlet
extends HttpServlet {
    private Map<String, Set<IPlatformWebResource>> contextResourcesMap = new HashMap<String, Set<IPlatformWebResource>>();
    public static final String WEB_CONTEXT_JS = "webcontext.js";

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        String requestStr = httpRequest.getRequestURI();
        if (requestStr != null && requestStr.contains(WEB_CONTEXT_JS)) {
            httpResponse.setContentType("text/javascript");
            String contextPath = "/";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("var CONTEXT_PATH = '" + contextPath + "';\nvar dojoConfig = [];\n\n");
            Locale effectiveLocale = this.getLocale();
            if (StringUtils.isNotEmpty((String)httpRequest.getParameter("locale"))) {
                effectiveLocale = new Locale(httpRequest.getParameter("locale"));
            }
            this.appendLocale(stringBuilder, effectiveLocale);
            String context = null;
            if (StringUtils.isNotEmpty((String)httpRequest.getParameter("context"))) {
                context = httpRequest.getParameter("context");
            }
            this.appendJsWebResources(stringBuilder, this.getWebResources(context, ".*\\.js"));
            this.appendCssWebResources(stringBuilder, this.getWebResources(context, ".*\\.css"));
            String requireJsLocation = "requirejs-manager/js/require-init.js";
            stringBuilder.append("document.write(\"<script type='text/javascript' src='" + contextPath + requireJsLocation + "'></scr\"+\"ipt>\");\n");
            httpResponse.getWriter().write(stringBuilder.toString());
        } else {
            httpResponse.sendError(404);
        }
    }

    List<String> getWebResources(String context, String filePattern) {
        Set<IPlatformWebResource> resources = this.contextResourcesMap.get(context);
        if (CollectionUtils.isNotEmpty(resources)) {
            List<String> webResources = resources.stream().filter(iPlatformWebResource -> iPlatformWebResource.getLocation().matches(filePattern)).map(IPlatformWebResource::getLocation).collect(Collectors.toList());
            return webResources;
        }
        return Collections.EMPTY_LIST;
    }

    Locale getLocale() {
        Locale defaultLocale = LanguageChoice.getInstance().getDefaultLocale();
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        return defaultLocale;
    }

    void appendLocale(StringBuilder sb, Locale locale) {
        sb.append("var SESSION_LOCALE = '" + locale.toString() + "';\n").append("if(typeof(pen) != 'undefined' && pen.define){pen.define('Locale', {locale:'" + locale.toString() + "'})};\n");
    }

    public void destroy() {
    }

    public void addPlatformWebResource(IPlatformWebResource resource) {
        if (resource != null && !this.contextResourcesMap.containsKey(resource.getContext())) {
            this.contextResourcesMap.put(resource.getContext(), new HashSet());
        }
        this.contextResourcesMap.get(resource.getContext()).add(resource);
    }

    public void removePlatformWebResource(IPlatformWebResource resource) {
        if (resource != null && this.contextResourcesMap.containsKey(resource.getContext())) {
            this.contextResourcesMap.get(resource.getContext()).remove(resource);
        }
    }

    void appendJsWebResources(StringBuilder sb, List<String> resources) {
        resources.stream().forEach(s -> {
            if (s.startsWith("/")) {
                s = s.substring(1);
            }
            sb.append("document.write(\"<script type='text/javascript' src='/" + s + "'></scr\"+\"ipt>\");\n");
        });
    }

    void appendCssWebResources(StringBuilder sb, List<String> resources) {
        resources.stream().forEach(s -> {
            if (s.startsWith("/")) {
                s = s.substring(1);
            }
            sb.append("document.write(\"<link rel='stylesheet' type='text/css' href='/" + s + "'>\");\n");
        });
    }
}

