/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class ExpiredMobFileCleaner
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ExpiredMobFileCleaner.class);

    public void cleanExpiredMobFiles(String tableName, HColumnDescriptor family) throws ServiceException, IOException {
        Configuration conf = this.getConf();
        TableName tn = TableName.valueOf((String)tableName);
        FileSystem fs = FileSystem.get((Configuration)conf);
        LOG.info((Object)("Cleaning the expired MOB files of " + family.getNameAsString() + " in " + tableName));
        Configuration copyOfConf = new Configuration(conf);
        copyOfConf.setFloat("hfile.block.cache.size", 0.0f);
        CacheConfig cacheConfig = new CacheConfig(copyOfConf);
        MobUtils.cleanExpiredMobFiles(fs, conf, tn, family, cacheConfig, EnvironmentEdgeManager.currentTime());
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        ToolRunner.run((Configuration)conf, (Tool)new ExpiredMobFileCleaner(), (String[])args);
    }

    private void printUsage() {
        System.err.println("Usage:\n--------------------------\n" + ExpiredMobFileCleaner.class.getName() + " tableName familyName");
        System.err.println(" tableName        The table name");
        System.err.println(" familyName       The column family name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            this.printUsage();
            return 1;
        }
        String tableName = args[0];
        String familyName = args[1];
        TableName tn = TableName.valueOf((String)tableName);
        HBaseAdmin.checkHBaseAvailable((Configuration)this.getConf());
        HBaseAdmin admin = new HBaseAdmin(this.getConf());
        try {
            HTableDescriptor htd = admin.getTableDescriptor(tn);
            HColumnDescriptor family = htd.getFamily(Bytes.toBytes((String)familyName));
            if (family == null || !family.isMobEnabled()) {
                throw new IOException("Column family " + familyName + " is not a MOB column family");
            }
            if (family.getMinVersions() > 0) {
                throw new IOException("The minVersions of the column family is not 0, could not be handled by this cleaner");
            }
            this.cleanExpiredMobFiles(tableName, family);
            int n = 0;
            return n;
        }
        finally {
            try {
                admin.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Fail to close the HBaseAdmin.", (Throwable)e);
            }
        }
    }
}

