/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ReplicationChecker {
    private static final Log LOG = LogFactory.getLog(ReplicationChecker.class);
    private HBaseFsck.ErrorReporter errorReporter;
    private ReplicationQueuesClient queuesClient;
    private ReplicationPeers replicationPeers;
    private ReplicationQueueDeletor queueDeletor;
    private Map<String, List<String>> undeletedQueueIds = new HashMap<String, List<String>>();

    public ReplicationChecker(Configuration conf, ZooKeeperWatcher zkw, HConnection connection, HBaseFsck.ErrorReporter errorReporter) throws IOException {
        try {
            this.errorReporter = errorReporter;
            this.queuesClient = ReplicationFactory.getReplicationQueuesClient((ZooKeeperWatcher)zkw, (Configuration)conf, (Abortable)connection);
            this.queuesClient.init();
            this.replicationPeers = ReplicationFactory.getReplicationPeers((ZooKeeperWatcher)zkw, (Configuration)conf, (ReplicationQueuesClient)this.queuesClient, (Abortable)connection);
            this.replicationPeers.init();
            this.queueDeletor = new ReplicationQueueDeletor(zkw, conf, (Abortable)connection);
        }
        catch (ReplicationException e) {
            throw new IOException("failed to construct ReplicationChecker", e);
        }
    }

    public boolean hasUnDeletedQueues() {
        return this.errorReporter.getErrorList().contains((Object)HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE);
    }

    public void checkUnDeletedQueues() throws IOException {
        HashSet peerIds = new HashSet(this.replicationPeers.getAllPeerIds());
        try {
            List replicators = this.queuesClient.getListOfReplicators();
            for (String replicator : replicators) {
                List queueIds = this.queuesClient.getAllQueues(replicator);
                for (String queueId : queueIds) {
                    ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                    if (peerIds.contains(queueInfo.getPeerId())) continue;
                    if (!this.undeletedQueueIds.containsKey(replicator)) {
                        this.undeletedQueueIds.put(replicator, new ArrayList());
                    }
                    this.undeletedQueueIds.get(replicator).add(queueId);
                    String msg = "Undeleted replication queue for removed peer found: " + String.format("[removedPeerId=%s, replicator=%s, queueId=%s]", queueInfo.getPeerId(), replicator, queueId);
                    this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, msg);
                }
            }
        }
        catch (KeeperException ke) {
            throw new IOException(ke);
        }
    }

    public void fixUnDeletedQueues() throws IOException {
        for (Map.Entry<String, List<String>> replicatorAndQueueIds : this.undeletedQueueIds.entrySet()) {
            String replicator = replicatorAndQueueIds.getKey();
            for (String queueId : replicatorAndQueueIds.getValue()) {
                this.queueDeletor.removeQueue(replicator, queueId);
            }
        }
    }

    private static class ReplicationQueueDeletor
    extends ReplicationStateZKBase {
        public ReplicationQueueDeletor(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
            super(zk, conf, abortable);
        }

        public void removeQueue(String replicator, String queueId) throws IOException {
            String queueZnodePath = ZKUtil.joinZNode((String)ZKUtil.joinZNode((String)this.queuesZNode, (String)replicator), (String)queueId);
            try {
                ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)this.zookeeper, (String)queueZnodePath);
                LOG.info((Object)("remove replication queue, replicator: " + replicator + ", queueId: " + queueId));
            }
            catch (KeeperException e) {
                throw new IOException("failed to delete queue, replicator: " + replicator + ", queueId: " + queueId);
            }
        }
    }
}

