/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryAccessDeniedException;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.springframework.util.Assert;

public class DefaultUnifiedRepository
implements IUnifiedRepository {
    private IRepositoryFileDao repositoryFileDao;
    private IRepositoryFileAclDao repositoryFileAclDao;

    public DefaultUnifiedRepository(IRepositoryFileDao contentDao, IRepositoryFileAclDao aclDao) {
        Assert.notNull((Object)contentDao);
        Assert.notNull((Object)aclDao);
        this.repositoryFileDao = contentDao;
        this.repositoryFileAclDao = aclDao;
    }

    public List<RepositoryFileAce> getEffectiveAces(Serializable fileId) {
        return this.getEffectiveAces(fileId, false);
    }

    public List<RepositoryFileAce> getEffectiveAces(Serializable fileId, boolean forceEntriesInheriting) {
        return this.repositoryFileAclDao.getEffectiveAces(fileId, forceEntriesInheriting);
    }

    public boolean hasAccess(String path, EnumSet<RepositoryFilePermission> permissions) {
        return this.repositoryFileAclDao.hasAccess(path, permissions);
    }

    public RepositoryFile getFile(String path) {
        Assert.hasText((String)path);
        return this.repositoryFileDao.getFile(path, false);
    }

    public RepositoryFile getFileById(Serializable fileId) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getFileById(fileId, false);
    }

    public RepositoryFile getFile(String path, boolean loadMaps) {
        Assert.hasText((String)path);
        return this.repositoryFileDao.getFile(path, loadMaps);
    }

    public RepositoryFile getFileById(Serializable fileId, boolean loadMaps) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getFileById(fileId, loadMaps);
    }

    public RepositoryFile getFile(String path, IPentahoLocale locale) {
        return this.repositoryFileDao.getFile(path, locale);
    }

    public RepositoryFile getFileById(Serializable fileId, IPentahoLocale locale) {
        return this.repositoryFileDao.getFileById(fileId, locale);
    }

    public RepositoryFile getFile(String path, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.repositoryFileDao.getFile(path, loadLocaleMaps, locale);
    }

    public RepositoryFile getFileById(Serializable fileId, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.repositoryFileDao.getFileById(fileId, loadLocaleMaps, locale);
    }

    public RepositoryFile createFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData data, String versionMessage) {
        return this.createFile(parentFolderId, file, data, null, versionMessage);
    }

    public RepositoryFile createFolder(Serializable parentFolderId, RepositoryFile file, String versionMessage) {
        return this.createFolder(parentFolderId, file, null, versionMessage);
    }

    public RepositoryFile createFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData data, RepositoryFileAcl acl, String versionMessage) {
        Assert.notNull((Object)file);
        Assert.isTrue((!file.isFolder() ? 1 : 0) != 0);
        Assert.notNull((Object)data);
        Assert.notNull((Object)parentFolderId);
        return this.internalCreateFile(parentFolderId, file, data, acl, versionMessage);
    }

    public RepositoryFile createFolder(Serializable parentFolderId, RepositoryFile file, RepositoryFileAcl acl, String versionMessage) {
        Assert.notNull((Object)file);
        Assert.isTrue((boolean)file.isFolder());
        Assert.notNull((Object)parentFolderId);
        return this.internalCreateFolder(parentFolderId, file, acl, versionMessage);
    }

    public <T extends IRepositoryFileData> T getDataForExecute(Serializable fileId, Class<T> dataClass) {
        return this.getDataAtVersionForExecute(fileId, null, dataClass);
    }

    public <T extends IRepositoryFileData> T getDataAtVersionForExecute(Serializable fileId, Serializable versionId, Class<T> dataClass) {
        return this.getDataAtVersionForRead(fileId, versionId, dataClass);
    }

    public <T extends IRepositoryFileData> T getDataForRead(Serializable fileId, Class<T> dataClass) {
        return this.getDataAtVersionForRead(fileId, null, dataClass);
    }

    public <T extends IRepositoryFileData> T getDataAtVersionForRead(Serializable fileId, Serializable versionId, Class<T> dataClass) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getData(fileId, versionId, dataClass);
    }

    public <T extends IRepositoryFileData> List<T> getDataForReadInBatch(List<RepositoryFile> files, Class<T> dataClass) {
        Assert.notNull(files);
        ArrayList<T> data = new ArrayList<T>(files.size());
        for (RepositoryFile f : files) {
            Assert.notNull((Object)f);
            data.add(this.getDataAtVersionForRead(f.getId(), f.getVersionId(), dataClass));
        }
        return data;
    }

    public <T extends IRepositoryFileData> List<T> getDataForExecuteInBatch(List<RepositoryFile> files, Class<T> dataClass) {
        return this.getDataForReadInBatch(files, dataClass);
    }

    public List<RepositoryFile> getChildren(RepositoryRequest repositoryRequest) {
        return this.repositoryFileDao.getChildren(repositoryRequest);
    }

    public List<RepositoryFile> getChildren(Serializable folderId) {
        return this.getChildren(folderId, null, null);
    }

    public List<RepositoryFile> getChildren(Serializable folderId, String filter) {
        return this.getChildren(folderId, filter, null);
    }

    public List<RepositoryFile> getChildren(Serializable folderId, String filter, Boolean showHiddenFiles) {
        Assert.notNull((Object)folderId);
        return this.repositoryFileDao.getChildren(new RepositoryRequest(folderId.toString(), showHiddenFiles, Integer.valueOf(-1), filter));
    }

    public RepositoryFile updateFile(RepositoryFile file, IRepositoryFileData data, String versionMessage) {
        Assert.notNull((Object)file);
        Assert.notNull((Object)data);
        return this.internalUpdateFile(file, data, versionMessage);
    }

    public void deleteFile(Serializable fileId, boolean permanent, String versionMessage) {
        Assert.notNull((Object)fileId);
        if (permanent) {
            this.repositoryFileDao.permanentlyDeleteFile(fileId, versionMessage);
        } else {
            this.repositoryFileDao.deleteFile(fileId, versionMessage);
        }
    }

    public void deleteFile(Serializable fileId, String versionMessage) {
        this.deleteFile(fileId, false, versionMessage);
    }

    public void deleteFileAtVersion(Serializable fileId, Serializable versionId) {
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        this.repositoryFileDao.deleteFileAtVersion(fileId, versionId);
    }

    public List<RepositoryFile> getDeletedFiles(String origParentFolderPath) {
        return this.getDeletedFiles(origParentFolderPath, null);
    }

    public List<RepositoryFile> getDeletedFiles(String origParentFolderPath, String filter) {
        Assert.hasLength((String)origParentFolderPath);
        return this.repositoryFileDao.getDeletedFiles(origParentFolderPath, filter);
    }

    public List<RepositoryFile> getDeletedFiles() {
        return this.repositoryFileDao.getDeletedFiles();
    }

    public void undeleteFile(Serializable fileId, String versionMessage) {
        Assert.notNull((Object)fileId);
        this.repositoryFileDao.undeleteFile(fileId, versionMessage);
    }

    public RepositoryFileAcl getAcl(Serializable fileId) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileAclDao.getAcl(fileId);
    }

    public void lockFile(Serializable fileId, String message) {
        Assert.notNull((Object)fileId);
        this.repositoryFileDao.lockFile(fileId, message);
    }

    public void unlockFile(Serializable fileId) {
        Assert.notNull((Object)fileId);
        this.repositoryFileDao.unlockFile(fileId);
    }

    public VersionSummary getVersionSummary(Serializable fileId, Serializable versionId) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getVersionSummary(fileId, versionId);
    }

    public List<VersionSummary> getVersionSummaryInBatch(List<RepositoryFile> files) {
        Assert.notNull(files);
        ArrayList<VersionSummary> summaries = new ArrayList<VersionSummary>(files.size());
        for (RepositoryFile file : files) {
            Assert.notNull((Object)file);
            summaries.add(this.getVersionSummary(file.getId(), file.getVersionId()));
        }
        return summaries;
    }

    public List<VersionSummary> getVersionSummaries(Serializable fileId) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getVersionSummaries(fileId);
    }

    public RepositoryFile getFileAtVersion(Serializable fileId, Serializable versionId) {
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        return this.repositoryFileDao.getFile(fileId, versionId);
    }

    public RepositoryFileAcl updateAcl(RepositoryFileAcl acl) {
        Assert.notNull((Object)acl);
        RepositoryFile file = this.getFileById(acl.getId());
        ArrayList<RepositoryFilePermission> perms = new ArrayList<RepositoryFilePermission>();
        perms.add(RepositoryFilePermission.ACL_MANAGEMENT);
        if (!this.hasAccess(file.getPath(), EnumSet.copyOf(perms))) {
            throw new UnifiedRepositoryAccessDeniedException(Messages.getInstance().getString("DefaultUnifiedRepository.ERROR_0001_ACCESS_DENIED_UPDATE_ACL", new Object[]{acl.getId()}));
        }
        return this.repositoryFileAclDao.updateAcl(acl);
    }

    public void moveFile(Serializable fileId, String destAbsPath, String versionMessage) {
        Assert.notNull((Object)fileId);
        Assert.hasText((String)destAbsPath);
        this.repositoryFileDao.moveFile(fileId, destAbsPath, versionMessage);
    }

    public void copyFile(Serializable fileId, String destAbsPath, String versionMessage) {
        Assert.notNull((Object)fileId);
        Assert.hasText((String)destAbsPath);
        this.repositoryFileDao.copyFile(fileId, destAbsPath, versionMessage);
    }

    public void restoreFileAtVersion(Serializable fileId, Serializable versionId, String versionMessage) {
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        this.repositoryFileDao.restoreFileAtVersion(fileId, versionId, versionMessage);
    }

    public boolean canUnlockFile(Serializable fileId) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.canUnlockFile(fileId);
    }

    public RepositoryFileTree getTree(RepositoryRequest repositoryRequest) {
        return this.repositoryFileDao.getTree(repositoryRequest);
    }

    @Deprecated
    public RepositoryFileTree getTree(String path, int depth, String filter, boolean showHidden) {
        Assert.hasText((String)path);
        return this.getTree(new RepositoryRequest(path, Boolean.valueOf(showHidden), Integer.valueOf(depth), filter));
    }

    private RepositoryFile internalCreateFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData data, RepositoryFileAcl acl, String versionMessage) {
        Assert.notNull((Object)file);
        Assert.notNull((Object)data);
        return this.repositoryFileDao.createFile(parentFolderId, file, data, acl, versionMessage);
    }

    private RepositoryFile internalCreateFolder(Serializable parentFolderId, RepositoryFile file, RepositoryFileAcl acl, String versionMessage) {
        Assert.notNull((Object)file);
        return this.repositoryFileDao.createFolder(parentFolderId, file, acl, versionMessage);
    }

    private RepositoryFile internalUpdateFolder(RepositoryFile file, String versionMessage) {
        Assert.notNull((Object)file);
        return this.repositoryFileDao.updateFolder(file, versionMessage);
    }

    private RepositoryFile internalUpdateFile(RepositoryFile file, IRepositoryFileData data, String versionMessage) {
        Assert.notNull((Object)file);
        Assert.notNull((Object)data);
        return this.repositoryFileDao.updateFile(file, data, versionMessage);
    }

    public List<RepositoryFile> getReferrers(Serializable fileId) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getReferrers(fileId);
    }

    public void setFileMetadata(Serializable fileId, Map<String, Serializable> metadataMap) {
        Assert.notNull((Object)fileId);
        this.repositoryFileDao.setFileMetadata(fileId, metadataMap);
    }

    public Map<String, Serializable> getFileMetadata(Serializable fileId) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getFileMetadata(fileId);
    }

    public List<Character> getReservedChars() {
        return this.repositoryFileDao.getReservedChars();
    }

    public List<Locale> getAvailableLocalesForFileById(Serializable fileId) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getAvailableLocalesForFileById(fileId);
    }

    public List<Locale> getAvailableLocalesForFileByPath(String relPath) {
        Assert.notNull((Object)relPath);
        return this.repositoryFileDao.getAvailableLocalesForFileByPath(relPath);
    }

    public List<Locale> getAvailableLocalesForFile(RepositoryFile repositoryFile) {
        Assert.notNull((Object)repositoryFile);
        return this.repositoryFileDao.getAvailableLocalesForFile(repositoryFile);
    }

    public Properties getLocalePropertiesForFileById(Serializable fileId, String locale) {
        Assert.notNull((Object)fileId);
        return this.repositoryFileDao.getLocalePropertiesForFileById(fileId, locale);
    }

    public Properties getLocalePropertiesForFileByPath(String relPath, String locale) {
        Assert.notNull((Object)relPath);
        return this.repositoryFileDao.getLocalePropertiesForFileByPath(relPath, locale);
    }

    public Properties getLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        Assert.notNull((Object)repositoryFile);
        return this.repositoryFileDao.getLocalePropertiesForFile(repositoryFile, locale);
    }

    public void setLocalePropertiesForFileById(Serializable fileId, String locale, Properties properties) {
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)locale);
        Assert.notNull((Object)properties);
        this.repositoryFileDao.setLocalePropertiesForFileById(fileId, locale, properties);
    }

    public void setLocalePropertiesForFileByPath(String relPath, String locale, Properties properties) {
        Assert.notNull((Object)relPath);
        Assert.notNull((Object)locale);
        Assert.notNull((Object)properties);
        this.repositoryFileDao.setLocalePropertiesForFileByPath(relPath, locale, properties);
    }

    public void setLocalePropertiesForFile(RepositoryFile repositoryFile, String locale, Properties properties) {
        Assert.notNull((Object)repositoryFile);
        Assert.notNull((Object)locale);
        Assert.notNull((Object)properties);
        this.repositoryFileDao.setLocalePropertiesForFile(repositoryFile, locale, properties);
    }

    public void deleteLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        Assert.notNull((Object)repositoryFile);
        Assert.notNull((Object)locale);
        this.repositoryFileDao.deleteLocalePropertiesForFile(repositoryFile, locale);
    }

    public RepositoryFile updateFolder(RepositoryFile folder, String versionMessage) {
        Assert.notNull((Object)folder);
        return this.internalUpdateFolder(folder, versionMessage);
    }
}

