/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.fileio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.repository.ContentException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileInputStream;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileOutputStream;
import org.pentaho.platform.util.web.MimeHelper;

public class RepositoryFileContentItem
implements IContentItem {
    RepositoryFileInputStream inputStream;
    RepositoryFileOutputStream outputStream;

    public RepositoryFileContentItem(String filePath) {
        this.outputStream = new RepositoryFileOutputStream(filePath, true, true, null, false);
    }

    RepositoryFileContentItem(RepositoryFileOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void closeOutputStream() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public IPentahoStreamSource getDataSource() {
        return new IPentahoStreamSource(){

            public OutputStream getOutputStream() throws IOException {
                return RepositoryFileContentItem.this.outputStream;
            }

            public String getName() {
                return RepositoryFilenameUtils.getName(RepositoryFileContentItem.this.getPath());
            }

            public InputStream getInputStream() throws IOException {
                return RepositoryFileContentItem.this.getInputStream();
            }

            public String getContentType() {
                return RepositoryFileContentItem.this.getMimeType();
            }
        };
    }

    public InputStream getInputStream() throws ContentException {
        if (this.inputStream == null) {
            try {
                RepositoryFileOutputStream outputStream = (RepositoryFileOutputStream)this.getOutputStream(null);
                if (outputStream.autoCreateUniqueFileName && !outputStream.flushed) {
                    throw new FileNotFoundException("File not yet versioned.");
                }
                if (this.inputStream == null) {
                    IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
                    RepositoryFile repositoryFile = repository.getFile(outputStream.path);
                    if (repositoryFile == null || repositoryFile.isFolder()) {
                        throw new FileNotFoundException();
                    }
                    return new RepositoryFileInputStream(repositoryFile);
                }
            }
            catch (FileNotFoundException e) {
                throw new ContentException((Throwable)e);
            }
            catch (IOException e) {
                throw new ContentException((Throwable)e);
            }
        }
        return this.inputStream;
    }

    public String getMimeType() {
        return MimeHelper.getMimeTypeFromExtension((String)("." + RepositoryFilenameUtils.getExtension(this.getPath())));
    }

    public OutputStream getOutputStream(String arg0) throws IOException {
        return this.outputStream;
    }

    public String getPath() {
        return this.outputStream.getFilePath();
    }

    public void setMimeType(String mimeType) {
        String fileExtension = MimeHelper.getExtension((String)mimeType);
        if (fileExtension == null) {
            throw new IllegalArgumentException("Unknown mime type");
        }
        String requestedFileExtension = MimeHelper.getExtension((String)mimeType);
        String currentExtension = RepositoryFilenameUtils.getExtension(this.outputStream.getFilePath());
        if (requestedFileExtension == null) {
            if (currentExtension != null) {
                String tempFilePath = RepositoryFilenameUtils.getFullPathNoEndSeparator(this.outputStream.getFilePath()) + "/" + RepositoryFilenameUtils.getBaseName(this.outputStream.getFilePath());
                this.outputStream.setFilePath(tempFilePath);
            }
        } else if (!requestedFileExtension.substring(1).equals(currentExtension.toLowerCase())) {
            String tempFilePath = RepositoryFilenameUtils.getFullPathNoEndSeparator(this.outputStream.getFilePath()) + "/" + RepositoryFilenameUtils.getBaseName(this.outputStream.getFilePath()) + requestedFileExtension;
            this.outputStream.setFilePath(tempFilePath);
        }
    }

    public void setName(String arg0) {
    }
}

