/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.sejcr;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.api.XASession;
import org.apache.jackrabbit.core.SessionImpl;
import org.pentaho.platform.repository2.unified.jcr.sejcr.ConstantCredentialsStrategy;
import org.pentaho.platform.repository2.unified.jcr.sejcr.CredentialsStrategy;
import org.pentaho.platform.repository2.unified.jcr.sejcr.GuavaCachePoolPentahoJcrSessionFactory;
import org.pentaho.platform.repository2.unified.jcr.sejcr.NodeTypeDefinitionProvider;
import org.pentaho.platform.repository2.unified.jcr.sejcr.PentahoJcrSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.jcr.EventListenerDefinition;
import org.springframework.extensions.jcr.JcrSessionFactory;
import org.springframework.extensions.jcr.JcrUtils;
import org.springframework.extensions.jcr.SessionFactory;
import org.springframework.extensions.jcr.SessionHolder;
import org.springframework.extensions.jcr.SessionHolderProvider;
import org.springframework.extensions.jcr.SessionHolderProviderManager;
import org.springframework.extensions.jcr.support.GenericSessionHolderProvider;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class CredentialsStrategySessionFactory
implements InitializingBean,
DisposableBean,
SessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JcrSessionFactory.class);
    private Repository repository;
    private String workspaceName;
    private CredentialsStrategy credentialsStrategy = new ConstantCredentialsStrategy();
    private CredentialsStrategy adminCredentialsStrategy = new ConstantCredentialsStrategy();
    private EventListenerDefinition[] eventListeners = new EventListenerDefinition[0];
    private Properties namespaces;
    private Map<String, String> overwrittenNamespaces;
    private boolean forceNamespacesRegistration = false;
    private boolean keepNewNamespaces = true;
    private boolean skipExistingNamespaces = true;
    private SessionHolderProviderManager sessionHolderProviderManager;
    private SessionHolderProvider sessionHolderProvider;
    private List<NodeTypeDefinitionProvider> nodeTypeDefinitionProviders;
    protected PentahoJcrSessionFactory sessionFactory;

    public CredentialsStrategySessionFactory(Repository repository, CredentialsStrategy credentialsStrategy) {
        this(repository, null, credentialsStrategy, null, null);
    }

    public CredentialsStrategySessionFactory(Repository repository, CredentialsStrategy credentialsStrategy, CredentialsStrategy adminCredentialsStrategy) {
        this(repository, null, credentialsStrategy, adminCredentialsStrategy, null);
    }

    public CredentialsStrategySessionFactory(Repository repository, String workspaceName, CredentialsStrategy credentialsStrategy, CredentialsStrategy adminCredentialsStrategy) {
        this(repository, workspaceName, credentialsStrategy, adminCredentialsStrategy, null);
    }

    public CredentialsStrategySessionFactory(Repository repository, String workspaceName, CredentialsStrategy credentialsStrategy, CredentialsStrategy adminCredentialsStrategy, SessionHolderProviderManager sessionHolderProviderManager) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.credentialsStrategy = credentialsStrategy;
        this.adminCredentialsStrategy = adminCredentialsStrategy;
        this.sessionHolderProviderManager = sessionHolderProviderManager;
    }

    public PentahoJcrSessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = new GuavaCachePoolPentahoJcrSessionFactory(this.repository, this.workspaceName, null);
        }
        return this.sessionFactory;
    }

    public void setSessionFactory(PentahoJcrSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getRepository(), (String)"repository is required");
        if (this.eventListeners != null && this.eventListeners.length > 0 && !JcrUtils.supportsObservation((Repository)this.getRepository())) {
            throw new IllegalArgumentException("repository " + this.getRepositoryInfo() + " does NOT support Observation; remove Listener definitions");
        }
        if (this.adminCredentialsStrategy != null) {
            this.registerNamespaces();
            this.registerNodeTypes();
        }
        if (this.sessionHolderProviderManager == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no session holder provider manager set; using the default one");
            }
            this.sessionHolderProvider = new GenericSessionHolderProvider();
        } else {
            this.sessionHolderProvider = this.sessionHolderProviderManager.getSessionProvider(this.getRepository());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerNodeTypes() throws Exception {
        if (!this.nodeTypeDefinitionProviders.isEmpty()) {
            Session session = null;
            try {
                session = this.getAdminSession();
                Workspace ws = session.getWorkspace();
                NodeTypeManager ntMgr = ws.getNodeTypeManager();
                ValueFactory vFac = session.getValueFactory();
                ArrayList<NodeTypeDefinition> ntds = new ArrayList<NodeTypeDefinition>();
                for (NodeTypeDefinitionProvider nodeTypeDefinitionProvider : this.nodeTypeDefinitionProviders) {
                    ntds.add(nodeTypeDefinitionProvider.getNodeTypeDefinition(ntMgr, vFac));
                }
                ntMgr.registerNodeTypes(ntds.toArray(new NodeTypeDefinition[0]), true);
            }
            catch (RepositoryException ex) {
                LOG.error("Error registering nodetypes ", ex.getCause());
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    public void setNodeTypeDefinitionProviders(List<NodeTypeDefinitionProvider> nodeTypeDefinitionProviders) {
        this.nodeTypeDefinitionProviders = nodeTypeDefinitionProviders;
    }

    protected void unregisterNodeTypes() throws Exception {
    }

    protected void registerNamespaces() throws Exception {
        if (this.namespaces == null || this.namespaces.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("registering custom namespaces " + this.namespaces);
        }
        Session session = this.getAdminSession();
        NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
        Object[] prefixes = registry.getPrefixes();
        Arrays.sort(prefixes);
        if (this.forceNamespacesRegistration) {
            if (!this.keepNewNamespaces) {
                this.overwrittenNamespaces = new HashMap<String, String>(this.namespaces.size());
            }
            for (Object key : this.namespaces.keySet()) {
                String prefix = (String)key;
                int position = Arrays.binarySearch(prefixes, prefix);
                if (position < 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("prefix " + prefix + " was already registered; unregistering it");
                }
                if (!this.keepNewNamespaces) {
                    this.overwrittenNamespaces.put(prefix, registry.getURI(prefix));
                }
                registry.unregisterNamespace(prefix);
            }
        }
        Iterator<Object> iterator = this.namespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry namespace = entry = (Map.Entry)iterator.next();
            String prefix = (String)namespace.getKey();
            String ns = (String)namespace.getValue();
            int position = Arrays.binarySearch(prefixes, prefix);
            if (this.skipExistingNamespaces && position >= 0) {
                LOG.debug("namespace already registered under [" + prefix + "]; skipping registration");
                continue;
            }
            LOG.debug("registering namespace [" + ns + "] under [" + prefix + "]");
            registry.registerNamespace(prefix, ns);
        }
        session.logout();
    }

    public void destroy() throws Exception {
        if (this.adminCredentialsStrategy != null) {
            this.unregisterNamespaces();
            this.unregisterNodeTypes();
        }
    }

    protected void unregisterNamespaces() throws Exception {
        if (this.namespaces == null || this.namespaces.isEmpty() || this.keepNewNamespaces) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("unregistering custom namespaces " + this.namespaces);
        }
        NamespaceRegistry registry = this.getSession().getWorkspace().getNamespaceRegistry();
        for (Object key : this.namespaces.keySet()) {
            String prefix = (String)key;
            registry.unregisterNamespace(prefix);
        }
        if (this.forceNamespacesRegistration) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("reverting back overwritten namespaces " + this.overwrittenNamespaces);
            }
            if (this.overwrittenNamespaces != null) {
                Iterator<Object> iterator = this.overwrittenNamespaces.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry namespace = entry = (Map.Entry)iterator.next();
                    registry.registerNamespace((String)namespace.getKey(), (String)namespace.getValue());
                }
            }
        }
    }

    public Session getAdminSession() throws RepositoryException {
        return this.adminCredentialsStrategy != null ? this.repository.login(this.adminCredentialsStrategy.getCredentials(), this.workspaceName) : null;
    }

    public Session getSession() throws RepositoryException {
        Credentials creds = this.credentialsStrategy.getCredentials();
        if (LOG.isDebugEnabled()) {
            LOG.debug("using credentials:" + creds);
        }
        Session session = this.getSessionFactory().getSession(creds);
        session = this.createSessionProxy(session);
        return this.addListeners(session);
    }

    public Session createSessionProxy(Session session) {
        return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Session.class, XASession.class}, (InvocationHandler)new LogoutSuppressingInvocationHandler(session));
    }

    public SessionHolder getSessionHolder(Session session) {
        return this.sessionHolderProvider.createSessionHolder(session);
    }

    protected Session addListeners(Session session) throws RepositoryException {
        if (this.eventListeners != null && this.eventListeners.length > 0) {
            Workspace ws = session.getWorkspace();
            ObservationManager manager = ws.getObservationManager();
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding listeners " + Arrays.asList(this.eventListeners).toString() + " for session " + session);
            }
            for (int i = 0; i < this.eventListeners.length; ++i) {
                manager.addEventListener(this.eventListeners[i].getListener(), this.eventListeners[i].getEventTypes(), this.eventListeners[i].getAbsPath(), this.eventListeners[i].isDeep(), this.eventListeners[i].getUuid(), this.eventListeners[i].getNodeTypeName(), this.eventListeners[i].isNoLocal());
            }
        }
        return session;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JcrSessionFactory) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.repository.hashCode();
        if (this.workspaceName != null) {
            result = 37 * result + this.workspaceName.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SessionFactory for ");
        buffer.append(this.getRepositoryInfo());
        buffer.append("|workspace=");
        buffer.append(this.workspaceName);
        return buffer.toString();
    }

    public EventListenerDefinition[] getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(EventListenerDefinition[] eventListenerDefinitions) {
        this.eventListeners = eventListenerDefinitions;
    }

    private String getRepositoryInfo() {
        if (this.getRepository() == null) {
            return "<N/A>";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getRepository().getDescriptor("jcr.repository.name"));
        buffer.append(" ");
        buffer.append(this.getRepository().getDescriptor("jcr.repository.version"));
        return buffer.toString();
    }

    public Properties getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Properties namespaces) {
        this.namespaces = namespaces;
    }

    protected SessionHolderProvider getSessionHolderProvider() {
        return this.sessionHolderProvider;
    }

    protected void setSessionHolderProvider(SessionHolderProvider sessionHolderProvider) {
        this.sessionHolderProvider = sessionHolderProvider;
    }

    public SessionHolderProviderManager getSessionHolderProviderManager() {
        return this.sessionHolderProviderManager;
    }

    public void setSessionHolderProviderManager(SessionHolderProviderManager sessionHolderProviderManager) {
        this.sessionHolderProviderManager = sessionHolderProviderManager;
    }

    public void setKeepNewNamespaces(boolean keepNamespaces) {
        this.keepNewNamespaces = keepNamespaces;
    }

    public void setForceNamespacesRegistration(boolean forceNamespacesRegistration) {
        this.forceNamespacesRegistration = forceNamespacesRegistration;
    }

    public void setSkipExistingNamespaces(boolean skipRegisteredNamespace) {
        this.skipExistingNamespaces = skipRegisteredNamespace;
    }

    public boolean isForceNamespacesRegistration() {
        return this.forceNamespacesRegistration;
    }

    public boolean isKeepNewNamespaces() {
        return this.keepNewNamespaces;
    }

    public boolean isSkipExistingNamespaces() {
        return this.skipExistingNamespaces;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public static class LogoutSuppressingInvocationHandler
    implements InvocationHandler {
        private LogoutDelegate logoutDelegate = LogoutDelegate.DefaultLogoutDelegate;
        private final Session target;

        public LogoutSuppressingInvocationHandler(Session target) {
            this.target = target;
        }

        public void setLogoutDelegate(LogoutDelegate delegate) {
            this.logoutDelegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("logout")) {
                if (this.logoutDelegate.shouldLogout()) {
                    this.target.logout();
                }
                return null;
            }
            try {
                Object ex = method.invoke((Object)this.target, args);
                return ex;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        public SessionImpl getSession() {
            return (SessionImpl)this.target;
        }

        protected void finalize() throws Throwable {
            if (this.target.isLive()) {
                // empty if block
            }
        }

        public static interface LogoutDelegate {
            public static final LogoutDelegate DefaultLogoutDelegate = new LogoutDelegate(){

                @Override
                public boolean shouldLogout() {
                    return !TransactionSynchronizationManager.isCurrentTransactionReadOnly();
                }
            };

            public boolean shouldLogout();
        }
    }
}

