/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeDetail;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeInfos;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingActivityTasksRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingDecisionTasksRequest;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.DeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DomainDetail;
import com.amazonaws.services.simpleworkflow.model.DomainInfos;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.ListActivityTypesRequest;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListDomainsRequest;
import com.amazonaws.services.simpleworkflow.model.ListOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListWorkflowTypesRequest;
import com.amazonaws.services.simpleworkflow.model.PendingTaskCount;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionCount;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfos;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeInfos;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTaskJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTaskStatusJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountClosedWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountOpenWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountPendingActivityTasksRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountPendingDecisionTasksRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DecisionTaskJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DefaultUndefinedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainDeprecatedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.GetWorkflowExecutionHistoryRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.HistoryJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListActivityTypesRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListClosedWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListOpenWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListWorkflowTypesRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.OperationNotPermittedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PendingTaskCountJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PollForActivityTaskRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PollForDecisionTaskRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RecordActivityTaskHeartbeatRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RequestCancelWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskCanceledRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskCompletedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskFailedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondDecisionTaskCompletedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RunJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.SignalWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.StartWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TerminateWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TypeAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TypeDeprecatedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.UnknownResourceExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionAlreadyStartedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionCountJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeInfosJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleWorkflowClient
extends AmazonWebServiceClient
implements AmazonSimpleWorkflow {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSimpleWorkflow.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonSimpleWorkflowClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSimpleWorkflowClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSimpleWorkflowClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleWorkflowClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonSimpleWorkflowClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonSimpleWorkflowClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DomainAlreadyExistsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DomainDeprecatedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DefaultUndefinedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new OperationNotPermittedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UnknownResourceExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new WorkflowExecutionAlreadyStartedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TypeDeprecatedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TypeAlreadyExistsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("swf.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpleworkflow/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simpleworkflow/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        config = new ClientConfiguration(orig);
        if (config.getMaxConnections() == 50) {
            log.debug((Object)"Overriding default max connection value to: 1000");
            config.setMaxConnections(1000);
        }
        if (config.getSocketTimeout() == 50000) {
            log.debug((Object)"Overriding default socket timeout value to: 90000");
            config.setSocketTimeout(90000);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprecateWorkflowType(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) {
        Request<DeprecateWorkflowTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deprecateWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeprecateWorkflowTypeRequestMarshaller().marshall(deprecateWorkflowTypeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprecateDomain(DeprecateDomainRequest deprecateDomainRequest) {
        Request<DeprecateDomainRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deprecateDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeprecateDomainRequestMarshaller().marshall(deprecateDomainRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWorkflowType(RegisterWorkflowTypeRequest registerWorkflowTypeRequest) {
        Request<RegisterWorkflowTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(registerWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RegisterWorkflowTypeRequestMarshaller().marshall(registerWorkflowTypeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTypeInfos listWorkflowTypes(ListWorkflowTypesRequest listWorkflowTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkflowTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkflowTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkflowTypesRequestMarshaller().marshall(listWorkflowTypesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            WorkflowTypeInfosJsonUnmarshaller unmarshaller = new WorkflowTypeInfosJsonUnmarshaller();
            JsonResponseHandler<WorkflowTypeInfos> responseHandler = new JsonResponseHandler<WorkflowTypeInfos>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowTypeInfos workflowTypeInfos = (WorkflowTypeInfos)response.getAwsResponse();
            return workflowTypeInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Run startWorkflowExecution(StartWorkflowExecutionRequest startWorkflowExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartWorkflowExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartWorkflowExecutionRequestMarshaller().marshall(startWorkflowExecutionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RunJsonUnmarshaller unmarshaller = new RunJsonUnmarshaller();
            JsonResponseHandler<Run> responseHandler = new JsonResponseHandler<Run>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            Run run = (Run)response.getAwsResponse();
            return run;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalWorkflowExecution(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) {
        Request<SignalWorkflowExecutionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(signalWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SignalWorkflowExecutionRequestMarshaller().marshall(signalWorkflowExecutionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainInfos listDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestMarshaller().marshall(listDomainsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DomainInfosJsonUnmarshaller unmarshaller = new DomainInfosJsonUnmarshaller();
            JsonResponseHandler<DomainInfos> responseHandler = new JsonResponseHandler<DomainInfos>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DomainInfos domainInfos = (DomainInfos)response.getAwsResponse();
            return domainInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) {
        Request<RequestCancelWorkflowExecutionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(requestCancelWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RequestCancelWorkflowExecutionRequestMarshaller().marshall(requestCancelWorkflowExecutionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTypeDetail describeWorkflowType(DescribeWorkflowTypeRequest describeWorkflowTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkflowTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkflowTypeRequestMarshaller().marshall(describeWorkflowTypeRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            WorkflowTypeDetailJsonUnmarshaller unmarshaller = new WorkflowTypeDetailJsonUnmarshaller();
            JsonResponseHandler<WorkflowTypeDetail> responseHandler = new JsonResponseHandler<WorkflowTypeDetail>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowTypeDetail workflowTypeDetail = (WorkflowTypeDetail)response.getAwsResponse();
            return workflowTypeDetail;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprecateActivityType(DeprecateActivityTypeRequest deprecateActivityTypeRequest) {
        Request<DeprecateActivityTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deprecateActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeprecateActivityTypeRequestMarshaller().marshall(deprecateActivityTypeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionCount countClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(countClosedWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CountClosedWorkflowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CountClosedWorkflowExecutionsRequestMarshaller().marshall(countClosedWorkflowExecutionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            WorkflowExecutionCountJsonUnmarshaller unmarshaller = new WorkflowExecutionCountJsonUnmarshaller();
            JsonResponseHandler<WorkflowExecutionCount> responseHandler = new JsonResponseHandler<WorkflowExecutionCount>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionCount workflowExecutionCount = (WorkflowExecutionCount)response.getAwsResponse();
            return workflowExecutionCount;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingTaskCount countPendingActivityTasks(CountPendingActivityTasksRequest countPendingActivityTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(countPendingActivityTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CountPendingActivityTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CountPendingActivityTasksRequestMarshaller().marshall(countPendingActivityTasksRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            PendingTaskCountJsonUnmarshaller unmarshaller = new PendingTaskCountJsonUnmarshaller();
            JsonResponseHandler<PendingTaskCount> responseHandler = new JsonResponseHandler<PendingTaskCount>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            PendingTaskCount pendingTaskCount = (PendingTaskCount)response.getAwsResponse();
            return pendingTaskCount;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) {
        Request<RespondActivityTaskCanceledRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskCanceledRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RespondActivityTaskCanceledRequestMarshaller().marshall(respondActivityTaskCanceledRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) {
        Request<RespondDecisionTaskCompletedRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(respondDecisionTaskCompletedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RespondDecisionTaskCompletedRequestMarshaller().marshall(respondDecisionTaskCompletedRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) {
        Request<RespondActivityTaskCompletedRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskCompletedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RespondActivityTaskCompletedRequestMarshaller().marshall(respondActivityTaskCompletedRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTask pollForActivityTask(PollForActivityTaskRequest pollForActivityTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForActivityTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForActivityTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForActivityTaskRequestMarshaller().marshall(pollForActivityTaskRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ActivityTaskJsonUnmarshaller unmarshaller = new ActivityTaskJsonUnmarshaller();
            JsonResponseHandler<ActivityTask> responseHandler = new JsonResponseHandler<ActivityTask>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ActivityTask activityTask = (ActivityTask)response.getAwsResponse();
            return activityTask;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionCount countOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(countOpenWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CountOpenWorkflowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CountOpenWorkflowExecutionsRequestMarshaller().marshall(countOpenWorkflowExecutionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            WorkflowExecutionCountJsonUnmarshaller unmarshaller = new WorkflowExecutionCountJsonUnmarshaller();
            JsonResponseHandler<WorkflowExecutionCount> responseHandler = new JsonResponseHandler<WorkflowExecutionCount>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionCount workflowExecutionCount = (WorkflowExecutionCount)response.getAwsResponse();
            return workflowExecutionCount;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTypeDetail describeActivityType(DescribeActivityTypeRequest describeActivityTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeActivityTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeActivityTypeRequestMarshaller().marshall(describeActivityTypeRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ActivityTypeDetailJsonUnmarshaller unmarshaller = new ActivityTypeDetailJsonUnmarshaller();
            JsonResponseHandler<ActivityTypeDetail> responseHandler = new JsonResponseHandler<ActivityTypeDetail>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ActivityTypeDetail activityTypeDetail = (ActivityTypeDetail)response.getAwsResponse();
            return activityTypeDetail;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionInfos listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOpenWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOpenWorkflowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOpenWorkflowExecutionsRequestMarshaller().marshall(listOpenWorkflowExecutionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            WorkflowExecutionInfosJsonUnmarshaller unmarshaller = new WorkflowExecutionInfosJsonUnmarshaller();
            JsonResponseHandler<WorkflowExecutionInfos> responseHandler = new JsonResponseHandler<WorkflowExecutionInfos>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionInfos workflowExecutionInfos = (WorkflowExecutionInfos)response.getAwsResponse();
            return workflowExecutionInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public History getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWorkflowExecutionHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWorkflowExecutionHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWorkflowExecutionHistoryRequestMarshaller().marshall(getWorkflowExecutionHistoryRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HistoryJsonUnmarshaller unmarshaller = new HistoryJsonUnmarshaller();
            JsonResponseHandler<History> responseHandler = new JsonResponseHandler<History>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            History history = (History)response.getAwsResponse();
            return history;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDomain(RegisterDomainRequest registerDomainRequest) {
        Request<RegisterDomainRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(registerDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RegisterDomainRequestMarshaller().marshall(registerDomainRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerActivityType(RegisterActivityTypeRequest registerActivityTypeRequest) {
        Request<RegisterActivityTypeRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(registerActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RegisterActivityTypeRequestMarshaller().marshall(registerActivityTypeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionInfos listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClosedWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClosedWorkflowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClosedWorkflowExecutionsRequestMarshaller().marshall(listClosedWorkflowExecutionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            WorkflowExecutionInfosJsonUnmarshaller unmarshaller = new WorkflowExecutionInfosJsonUnmarshaller();
            JsonResponseHandler<WorkflowExecutionInfos> responseHandler = new JsonResponseHandler<WorkflowExecutionInfos>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionInfos workflowExecutionInfos = (WorkflowExecutionInfos)response.getAwsResponse();
            return workflowExecutionInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTaskStatus recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) {
        ExecutionContext executionContext = this.createExecutionContext(recordActivityTaskHeartbeatRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RecordActivityTaskHeartbeatRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RecordActivityTaskHeartbeatRequestMarshaller().marshall(recordActivityTaskHeartbeatRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ActivityTaskStatusJsonUnmarshaller unmarshaller = new ActivityTaskStatusJsonUnmarshaller();
            JsonResponseHandler<ActivityTaskStatus> responseHandler = new JsonResponseHandler<ActivityTaskStatus>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ActivityTaskStatus activityTaskStatus = (ActivityTaskStatus)response.getAwsResponse();
            return activityTaskStatus;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecisionTask pollForDecisionTask(PollForDecisionTaskRequest pollForDecisionTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForDecisionTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForDecisionTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForDecisionTaskRequestMarshaller().marshall(pollForDecisionTaskRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DecisionTaskJsonUnmarshaller unmarshaller = new DecisionTaskJsonUnmarshaller();
            JsonResponseHandler<DecisionTask> responseHandler = new JsonResponseHandler<DecisionTask>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DecisionTask decisionTask = (DecisionTask)response.getAwsResponse();
            return decisionTask;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTypeInfos listActivityTypes(ListActivityTypesRequest listActivityTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listActivityTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListActivityTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListActivityTypesRequestMarshaller().marshall(listActivityTypesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ActivityTypeInfosJsonUnmarshaller unmarshaller = new ActivityTypeInfosJsonUnmarshaller();
            JsonResponseHandler<ActivityTypeInfos> responseHandler = new JsonResponseHandler<ActivityTypeInfos>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ActivityTypeInfos activityTypeInfos = (ActivityTypeInfos)response.getAwsResponse();
            return activityTypeInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainDetail describeDomain(DescribeDomainRequest describeDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDomainRequestMarshaller().marshall(describeDomainRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DomainDetailJsonUnmarshaller unmarshaller = new DomainDetailJsonUnmarshaller();
            JsonResponseHandler<DomainDetail> responseHandler = new JsonResponseHandler<DomainDetail>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DomainDetail domainDetail = (DomainDetail)response.getAwsResponse();
            return domainDetail;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondActivityTaskFailed(RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) {
        Request<RespondActivityTaskFailedRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskFailedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RespondActivityTaskFailedRequestMarshaller().marshall(respondActivityTaskFailedRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingTaskCount countPendingDecisionTasks(CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(countPendingDecisionTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CountPendingDecisionTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CountPendingDecisionTasksRequestMarshaller().marshall(countPendingDecisionTasksRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            PendingTaskCountJsonUnmarshaller unmarshaller = new PendingTaskCountJsonUnmarshaller();
            JsonResponseHandler<PendingTaskCount> responseHandler = new JsonResponseHandler<PendingTaskCount>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            PendingTaskCount pendingTaskCount = (PendingTaskCount)response.getAwsResponse();
            return pendingTaskCount;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) {
        Request<TerminateWorkflowExecutionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(terminateWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new TerminateWorkflowExecutionRequestMarshaller().marshall(terminateWorkflowExecutionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecutionDetail describeWorkflowExecution(DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkflowExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkflowExecutionRequestMarshaller().marshall(describeWorkflowExecutionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            WorkflowExecutionDetailJsonUnmarshaller unmarshaller = new WorkflowExecutionDetailJsonUnmarshaller();
            JsonResponseHandler<WorkflowExecutionDetail> responseHandler = new JsonResponseHandler<WorkflowExecutionDetail>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionDetail workflowExecutionDetail = (WorkflowExecutionDetail)response.getAwsResponse();
            return workflowExecutionDetail;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

