/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.region.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.karaf.region.commands.RegionCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;

@Command(scope="region", name="info", description="Prints information about region digraph.")
public class InfoCommand
extends RegionCommandSupport {
    @Option(name="-v", aliases={"--verbose"}, required=false, description="Show all info.")
    boolean verbose;
    @Option(name="-b", aliases={"--bundles"}, required=false, description="Show bundles in each region.")
    boolean bundles;
    @Option(name="-f", aliases={"--filters"}, required=false, description="Show filters.")
    boolean filters;
    @Option(name="-n", aliases={"--namespaces"}, required=false, description="Show namespaces in each filter.")
    boolean namespaces;
    @Argument(index=0, name="regions", description="Regions to provide detailed info for.", required=false, multiValued=true)
    List<String> regions;

    @Override
    protected void doExecute(RegionDigraph regionDigraph) throws Exception {
        System.out.println("Regions");
        if (this.regions == null) {
            for (Region region : regionDigraph.getRegions()) {
                this.showRegion(region);
            }
        } else {
            this.bundles = true;
            this.filters = true;
            this.namespaces = true;
            for (String regionName : this.regions) {
                Region region = regionDigraph.getRegion(regionName);
                if (region == null) {
                    System.out.println("No region " + regionName);
                    continue;
                }
                this.showRegion(region);
            }
        }
    }

    private void showRegion(Region region) {
        System.out.println(region.getName());
        if (this.verbose || this.bundles) {
            for (Long id : region.getBundleIds()) {
                Bundle b = this.getBundleContext().getBundle(id.longValue());
                System.out.println("  " + id + "  " + this.getStateString(b) + b);
            }
        }
        if (this.verbose || this.filters || this.namespaces) {
            for (RegionDigraph.FilteredRegion f : region.getEdges()) {
                System.out.println("  filter to " + f.getRegion().getName());
                if (!this.verbose && !this.namespaces) continue;
                RegionFilter rf = f.getFilter();
                for (Map.Entry policy : rf.getSharingPolicy().entrySet()) {
                    String namespace = (String)policy.getKey();
                    System.out.println("  namespace: " + namespace);
                    for (String e : (Collection)policy.getValue()) {
                        System.out.println("    " + e);
                    }
                }
            }
        }
    }

    public String getStateString(Bundle bundle) {
        if (bundle == null) {
            return "Bundle null";
        }
        int state = bundle.getState();
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }
}

