/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

public class SlaveConnectionManager {
    private static final String SSL = "SSL";
    private static final String KEYSTORE_SYSTEM_PROPERTY = "javax.net.ssl.keyStore";
    private static SlaveConnectionManager slaveConnectionManager;
    private MultiThreadedHttpConnectionManager manager;

    private SlaveConnectionManager() {
        if (SlaveConnectionManager.needToInitializeSSLContext()) {
            try {
                SSLContext context = SSLContext.getInstance(SSL);
                context.init(new KeyManager[0], new X509TrustManager[]{SlaveConnectionManager.getDefaultTrustManager()}, new SecureRandom());
                SSLContext.setDefault(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.manager = new MultiThreadedHttpConnectionManager();
        this.manager.getParams().setDefaultMaxConnectionsPerHost(100);
        this.manager.getParams().setMaxTotalConnections(200);
    }

    private static boolean needToInitializeSSLContext() {
        return System.getProperty(KEYSTORE_SYSTEM_PROPERTY) == null;
    }

    public static SlaveConnectionManager getInstance() {
        if (slaveConnectionManager == null) {
            slaveConnectionManager = new SlaveConnectionManager();
        }
        return slaveConnectionManager;
    }

    public HttpClient createHttpClient() {
        return new HttpClient((HttpConnectionManager)this.manager);
    }

    public void shutdown() {
        this.manager.shutdown();
    }

    private static X509TrustManager getDefaultTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String param) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String param) throws CertificateException {
                for (X509Certificate cert : certs) {
                    cert.checkValidity();
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }

    static void reset() {
        slaveConnectionManager = null;
    }
}

