/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class GenericDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public static final String ATRRIBUTE_CUSTOM_URL = "CUSTOM_URL";
    public static final String ATRRIBUTE_CUSTOM_DRIVER_CLASS = "CUSTOM_DRIVER_CLASS";

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            String driverClass = this.getAttributes().getProperty(ATRRIBUTE_CUSTOM_DRIVER_CLASS, "");
            return driverClass;
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 0) {
            String url = this.getAttributes().getProperty(ATRRIBUTE_CUSTOM_URL, "");
            return url;
        }
        return "jdbc:odbc:" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "BIGSERIAL";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = retval + "NUMERIC(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length < 5) {
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                retval = retval + "DOUBLE PRECISION";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "TEXT";
                    break;
                }
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(";
                retval = retval + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[0];
    }

    @Override
    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }

    @Override
    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }
}

