/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.encryption;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderInterface;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPlugin;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=TwoWayPasswordEncoderInterface.class)
@PluginAnnotationType(value=TwoWayPasswordEncoderPlugin.class)
public class TwoWayPasswordEncoderPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static TwoWayPasswordEncoderPluginType twoWayPasswordEncoderPluginType;

    private TwoWayPasswordEncoderPluginType() {
        super(TwoWayPasswordEncoderPlugin.class, "TWOWAYPASSWORDENCODERPLUGIN", "TwoWayPasswordEncoder");
        this.populateFolders("passwordencoder");
    }

    public static TwoWayPasswordEncoderPluginType getInstance() {
        if (twoWayPasswordEncoderPluginType == null) {
            twoWayPasswordEncoderPluginType = new TwoWayPasswordEncoderPluginType();
        }
        return twoWayPasswordEncoderPluginType;
    }

    @Override
    protected void registerNatives() throws KettlePluginException {
        String passwordEncoderPluginsXmlFile = "kettle-password-encoder-plugins.xml";
        String alternative = System.getProperty("KETTLE_PASSWORD_ENCODER_PLUGINS_FILE", null);
        if (!Utils.isEmpty(alternative)) {
            passwordEncoderPluginsXmlFile = alternative;
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(passwordEncoderPluginsXmlFile);
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("/" + passwordEncoderPluginsXmlFile);
            }
            if (inputStream == null && !Utils.isEmpty(alternative)) {
                try {
                    inputStream = new FileInputStream(passwordEncoderPluginsXmlFile);
                }
                catch (Exception e) {
                    throw new KettlePluginException("Unable to load native password encoder plugins '" + passwordEncoderPluginsXmlFile + "'", e);
                }
            }
            if (inputStream == null) {
                return;
            }
            Document document = XMLHandler.loadXMLFile(inputStream, null, true, false);
            Node stepsNode = XMLHandler.getSubNode(document, "password-encoder-plugins");
            List<Node> stepNodes = XMLHandler.getNodes(stepsNode, "password-encoder-plugin");
            for (Node stepNode : stepNodes) {
                this.registerPluginFromXmlResource(stepNode, null, this.getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle metadata plugins XML config file: " + passwordEncoderPluginsXmlFile, e);
        }
    }

    @Override
    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List<FileObject> pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile(file);
                    Node pluginNode = XMLHandler.getSubNode(document, "plugin");
                    if (pluginNode == null) continue;
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename(file.getParent()), this.getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading password encoder plugin.xml file: " + file.getName().toString(), e);
                }
            }
        }
    }

    @Override
    protected String extractCategory(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractDesc(Annotation annotation) {
        return ((TwoWayPasswordEncoderPlugin)annotation).description();
    }

    @Override
    protected String extractID(Annotation annotation) {
        return ((TwoWayPasswordEncoderPlugin)annotation).id();
    }

    @Override
    protected String extractName(Annotation annotation) {
        return ((TwoWayPasswordEncoderPlugin)annotation).name();
    }

    @Override
    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    @Override
    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return ((TwoWayPasswordEncoderPlugin)annotation).isSeparateClassLoaderNeeded();
    }

    @Override
    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    @Override
    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    @Override
    protected String extractDocumentationUrl(Annotation annotation) {
        return ((TwoWayPasswordEncoderPlugin)annotation).documentationUrl();
    }

    @Override
    protected String extractCasesUrl(Annotation annotation) {
        return ((TwoWayPasswordEncoderPlugin)annotation).casesUrl();
    }

    @Override
    protected String extractForumUrl(Annotation annotation) {
        return ((TwoWayPasswordEncoderPlugin)annotation).forumUrl();
    }

    @Override
    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((TwoWayPasswordEncoderPlugin)annotation).classLoaderGroup();
    }
}

