/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.pentaho.di.core.plugins.KettleURLClassLoader;

public class KettleSelectiveParentFirstClassLoader
extends KettleURLClassLoader {
    private final List<Pattern> patterns;

    public KettleSelectiveParentFirstClassLoader(URL[] url, ClassLoader classLoader, String[] patterns) {
        super(url, classLoader);
        this.patterns = this.initPatterns(patterns);
    }

    public KettleSelectiveParentFirstClassLoader(URL[] url, ClassLoader classLoader, String name, String[] patterns) {
        super(url, classLoader, name);
        this.patterns = this.initPatterns(patterns);
    }

    private List<Pattern> initPatterns(String[] patterns) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        if (patterns != null) {
            for (String pattern : patterns) {
                result.add(Pattern.compile(pattern));
            }
        }
        return result;
    }

    private Class<?> loadClassParentFirst(String arg0, boolean arg1) throws ClassNotFoundException {
        try {
            return this.loadClassFromParent(arg0, arg1);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return this.loadClassFromThisLoader(arg0, arg1);
    }

    @Override
    protected synchronized Class<?> loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(arg0).matches()) continue;
            return this.loadClassParentFirst(arg0, arg1);
        }
        return super.loadClass(arg0, arg1);
    }
}

