/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row.value;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.core.row.value.ValueMetaString;

public class ValueMetaFactory {
    public static PluginRegistry pluginRegistry = PluginRegistry.getInstance();

    public static ValueMetaInterface createValueMeta(String name, int type, int length, int precision) throws KettlePluginException {
        PluginInterface stringPlugin = pluginRegistry.getPlugin(ValueMetaPluginType.class, String.valueOf(type));
        if (stringPlugin == null) {
            throw new KettlePluginException("Unable to locate value meta plugin of type (id) " + type);
        }
        ValueMetaInterface valueMeta = pluginRegistry.loadClass(stringPlugin, ValueMetaInterface.class);
        valueMeta.setName(name);
        valueMeta.setLength(length, precision);
        return valueMeta;
    }

    public static ValueMetaInterface createValueMeta(String name, int type) throws KettlePluginException {
        return ValueMetaFactory.createValueMeta(name, type, -1, -1);
    }

    public static ValueMetaInterface createValueMeta(int type) throws KettlePluginException {
        return ValueMetaFactory.createValueMeta(null, type, -1, -1);
    }

    public static ValueMetaInterface cloneValueMeta(ValueMetaInterface source) throws KettlePluginException {
        return ValueMetaFactory.cloneValueMeta(source, source.getType());
    }

    public static ValueMetaInterface cloneValueMeta(ValueMetaInterface source, int targetType) throws KettlePluginException {
        ValueMetaInterface target = null;
        target = source.getType() == targetType ? source.clone() : ValueMetaFactory.createValueMeta(source.getName(), targetType, source.getLength(), source.getPrecision());
        target.setConversionMask(source.getConversionMask());
        target.setDecimalSymbol(source.getDecimalSymbol());
        target.setGroupingSymbol(source.getGroupingSymbol());
        target.setStorageType(source.getStorageType());
        if (source.getStorageMetadata() != null) {
            target.setStorageMetadata(ValueMetaFactory.cloneValueMeta(source.getStorageMetadata(), source.getStorageMetadata().getType()));
        }
        target.setStringEncoding(source.getStringEncoding());
        target.setTrimType(source.getTrimType());
        target.setDateFormatLenient(source.isDateFormatLenient());
        target.setDateFormatLocale(source.getDateFormatLocale());
        target.setDateFormatTimeZone(source.getDateFormatTimeZone());
        target.setLenientStringToNumber(source.isLenientStringToNumber());
        target.setLargeTextField(source.isLargeTextField());
        target.setComments(source.getComments());
        target.setCaseInsensitive(source.isCaseInsensitive());
        target.setCollatorDisabled(source.isCollatorDisabled());
        target.setCollatorStrength(source.getCollatorStrength());
        target.setIndex(source.getIndex());
        target.setOrigin(source.getOrigin());
        target.setOriginalAutoIncrement(source.isOriginalAutoIncrement());
        target.setOriginalColumnType(source.getOriginalColumnType());
        target.setOriginalColumnTypeName(source.getOriginalColumnTypeName());
        target.setOriginalNullable(source.isOriginalNullable());
        target.setOriginalPrecision(source.getOriginalPrecision());
        target.setOriginalScale(source.getOriginalScale());
        target.setOriginalSigned(source.isOriginalSigned());
        return target;
    }

    public static String[] getValueMetaNames() {
        ArrayList<String> strings = new ArrayList<String>();
        List plugins = pluginRegistry.getPlugins(ValueMetaPluginType.class);
        for (PluginInterface plugin : plugins) {
            int id = Integer.valueOf(plugin.getIds()[0]);
            if (id <= 0 || id == 7) continue;
            strings.add(plugin.getName());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String[] getAllValueMetaNames() {
        ArrayList<String> strings = new ArrayList<String>();
        List plugins = pluginRegistry.getPlugins(ValueMetaPluginType.class);
        for (PluginInterface plugin : plugins) {
            String id = plugin.getIds()[0];
            if ("0".equals(id)) continue;
            strings.add(plugin.getName());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String getValueMetaName(int type) {
        for (PluginInterface plugin : pluginRegistry.getPlugins(ValueMetaPluginType.class)) {
            if (!Integer.toString(type).equals(plugin.getIds()[0])) continue;
            return plugin.getName();
        }
        return "-";
    }

    public static int getIdForValueMeta(String valueMetaName) {
        for (PluginInterface plugin : pluginRegistry.getPlugins(ValueMetaPluginType.class)) {
            if (valueMetaName == null || !valueMetaName.equalsIgnoreCase(plugin.getName())) continue;
            return Integer.valueOf(plugin.getIds()[0]);
        }
        return 0;
    }

    public static List<ValueMetaInterface> getValueMetaPluginClasses() throws KettlePluginException {
        ArrayList<ValueMetaInterface> list = new ArrayList<ValueMetaInterface>();
        List plugins = pluginRegistry.getPlugins(ValueMetaPluginType.class);
        for (PluginInterface plugin : plugins) {
            ValueMetaInterface valueMetaInterface = (ValueMetaInterface)pluginRegistry.loadClass(plugin);
            list.add(valueMetaInterface);
        }
        return list;
    }

    public static ValueMetaInterface guessValueMetaInterface(Object object) {
        if (object instanceof Number) {
            if (object instanceof BigDecimal) {
                return new ValueMetaBigNumber();
            }
            if (object instanceof Double) {
                return new ValueMetaNumber();
            }
            if (object instanceof Long) {
                return new ValueMetaInteger();
            }
        } else {
            if (object instanceof String) {
                return new ValueMetaString();
            }
            if (object instanceof Date) {
                return new ValueMetaDate();
            }
            if (object instanceof Boolean) {
                return new ValueMetaBoolean();
            }
            if (object instanceof byte[]) {
                return new ValueMetaBinary();
            }
        }
        return null;
    }
}

