/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import com.cloudera.sqoop.mapreduce.db.DBRecordReader;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.mapreduce.DBWritable;

public class Db2DBRecordReader<T extends DBWritable>
extends DBRecordReader<T> {
    private static final Log LOG = LogFactory.getLog(Db2DBRecordReader.class);

    public Db2DBRecordReader(DBInputFormat.DBInputSplit split, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table) throws SQLException {
        super(split, inputClass, conf, conn, dbConfig, cond, fields, table);
    }

    @Override
    protected String getSelectQuery() {
        String query = super.getSelectQuery();
        if (this.getDBConf().getInputQuery() == null) {
            query = query.replace(" AS " + this.getTableName(), "");
        }
        return query;
    }
}

