/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TransactionToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransactionAttribute {
    MANDATORY{

        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 6) {
                throw new IllegalStateException(Constants.MESSAGES.getMessage("tran.not.found", new Object[0]));
            }
            return new TransactionToken(man.getTransaction(), null, MANDATORY);
        }
    }
    ,
    NEVER{

        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                throw new IllegalStateException(Constants.MESSAGES.getMessage("tran.found.never", new Object[0]));
            }
            return new TransactionToken(null, null, NEVER);
        }
    }
    ,
    NOTSUPPORTED{

        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                return new TransactionToken(null, man.suspend(), this);
            }
            return new TransactionToken(null, null, NOTSUPPORTED);
        }

        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException {
            Transaction tran = tranToken.getSuspendedTransaction();
            if (tran != null) {
                man.resume(tran);
            }
        }
    }
    ,
    REQUIRED{

        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException {
            if (man.getStatus() == 6) {
                man.begin();
                return new TransactionToken(man.getTransaction(), null, REQUIRED, true);
            }
            return new TransactionToken(man.getTransaction(), null, REQUIRED);
        }

        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
        }
    }
    ,
    REQUIRESNEW{

        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
            TransactionToken tranToken = man.getStatus() == 0 ? new TransactionToken(null, man.suspend(), REQUIRESNEW) : new TransactionToken(null, null, REQUIRESNEW);
            try {
                man.begin();
            }
            catch (SystemException e) {
                man.resume(tranToken.getSuspendedTransaction());
                throw e;
            }
            catch (NotSupportedException e) {
                man.resume(tranToken.getSuspendedTransaction());
                throw e;
            }
            tranToken.setActiveTransaction(man.getTransaction());
            tranToken.setCompletionAllowed(true);
            return tranToken;
        }

        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            Transaction tran;
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
            if ((tran = tranToken.getSuspendedTransaction()) != null) {
                man.resume(tran);
            }
        }
    }
    ,
    SUPPORTS{

        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
            if (man.getStatus() == 0) {
                return new TransactionToken(man.getTransaction(), null, SUPPORTS);
            }
            return new TransactionToken(null, null, SUPPORTS);
        }
    };


    public static TransactionAttribute fromValue(String value) {
        return TransactionAttribute.valueOf(value.toUpperCase());
    }

    public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
        return null;
    }

    public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
    }
}

