/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.openerp.objectinput;

import com.debortoliwines.openerp.api.FilterCollection;
import com.debortoliwines.openerp.api.Row;
import com.debortoliwines.openerp.api.RowCollection;
import java.util.ArrayList;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.openerp.core.FieldMapping;
import org.pentaho.di.openerp.core.OpenERPHelper;
import org.pentaho.di.openerp.core.ReadFilter;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.openerp.objectinput.OpenERPObjectInputData;
import org.pentaho.di.trans.steps.openerp.objectinput.OpenERPObjectInputMeta;

public class OpenERPObjectInput
extends BaseStep
implements StepInterface {
    private OpenERPObjectInputMeta meta;
    private OpenERPObjectInputData data;

    public OpenERPObjectInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void putRow(Row row, RowMetaInterface rowMeta) throws KettleStepException {
        ArrayList<FieldMapping> mappings = this.meta.getMappings();
        Object[] copyRow = new Object[mappings.size()];
        int i = 0;
        for (FieldMapping map : mappings) {
            Object value = row.get(map.source_field);
            copyRow[i] = map.source_index >= 0 && value != null && value instanceof Object[] ? (((Object[])value).length == 0 ? null : ((Object[])value)[map.source_index]) : value;
            copyRow[i] = this.fixType(map, copyRow[i]);
            ++i;
        }
        this.putRow(rowMeta, copyRow);
    }

    private Object fixType(FieldMapping map, Object value) {
        if (value == null) {
            return null;
        }
        Object fixedValue = value;
        if (map.target_field_type == 5) {
            fixedValue = Long.parseLong(value.toString());
        } else if (map.target_field_type == 1) {
            fixedValue = Double.parseDouble(value.toString());
        } else if (map.target_field_type == 2 && value instanceof Object[]) {
            String stringValue = "";
            for (Object singleValue : (Object[])value) {
                stringValue = stringValue + "," + singleValue.toString();
            }
            fixedValue = stringValue.substring(1);
        }
        return fixedValue;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.logBasic("Getting Field Row Meta.");
        this.logBasic("Getting Rows.");
        if (this.first) {
            this.first = false;
            try {
                RowMetaInterface rowMeta = this.meta.getRowMeta();
                FilterCollection filter = new FilterCollection();
                for (int i = 0; i < this.meta.getFilterList().size(); ++i) {
                    ReadFilter filterItem = this.meta.getFilterList().get(i);
                    if (filterItem.getOperator().equalsIgnoreCase("not")) {
                        filter.add(FilterCollection.FilterOperator.NOT);
                    } else if (filterItem.getOperator().equalsIgnoreCase("or")) {
                        filter.add(FilterCollection.FilterOperator.OR);
                    }
                    filter.add(filterItem.getFieldName(), filterItem.getComparator(), (Object)filterItem.getValue());
                    this.logBasic("Setting filter: [" + filterItem.getFieldName() + "," + filterItem.getComparator() + "," + filterItem.getValue() + "]");
                }
                int rowCount = this.data.helper.getModelDataCount(this.meta.getModelName(), filter);
                int offset = 0;
                int limit = this.meta.getReadBatchSize();
                while (offset < rowCount && !this.isStopped()) {
                    RowCollection rows = this.data.helper.getModelData(this.meta.getModelName(), filter, this.meta.getMappings(), offset, limit);
                    for (Row row : rows) {
                        try {
                            this.putRow(row, rowMeta);
                        }
                        catch (KettleStepException e) {
                            this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                            this.setErrors(1L);
                            this.stopAll();
                        }
                        this.incrementLinesInput();
                        ++offset;
                    }
                }
            }
            catch (Exception e) {
                throw new KettleException(e.getMessage());
            }
        }
        this.logBasic("Process Ended.");
        this.setOutputDone();
        return false;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (OpenERPObjectInputMeta)smi;
        this.data = (OpenERPObjectInputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.logDebug("Initializing OpenERP Session");
                this.data.helper = new OpenERPHelper(this.meta.getDatabaseMeta());
                this.data.helper.StartSession();
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }
}

