/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.vfs.KettleVFS;

public class LogChannelFileWriter {
    private String logChannelId;
    private FileObject logFile;
    private boolean appending;
    private int pollingInterval;
    private AtomicBoolean active;
    private KettleException exception;
    private int lastBufferLineNr;
    protected OutputStream logFileOutputStream;

    public LogChannelFileWriter(String logChannelId, FileObject logFile, boolean appending, int pollingInterval) throws KettleException {
        this.logChannelId = logChannelId;
        this.logFile = logFile;
        this.appending = appending;
        this.pollingInterval = pollingInterval;
        this.active = new AtomicBoolean(false);
        this.lastBufferLineNr = KettleLogStore.getLastBufferLineNr();
        try {
            this.logFileOutputStream = KettleVFS.getOutputStream((FileObject)logFile, (boolean)appending);
        }
        catch (IOException e) {
            throw new KettleException("There was an error while trying to open file '" + logFile + "' for writing", (Throwable)e);
        }
    }

    public LogChannelFileWriter(String logChannelId, FileObject logFile, boolean appending) throws KettleException {
        this(logChannelId, logFile, appending, 1000);
    }

    public void startLogging() {
        this.exception = null;
        this.active.set(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (LogChannelFileWriter.this.active.get() && LogChannelFileWriter.this.exception == null) {
                        LogChannelFileWriter.this.flush();
                        Thread.sleep(LogChannelFileWriter.this.pollingInterval);
                    }
                    LogChannelFileWriter.this.flush();
                }
                catch (Exception e) {
                    LogChannelFileWriter.this.exception = new KettleException("There was an error logging to file '" + LogChannelFileWriter.this.logFile + "'", (Throwable)e);
                }
                finally {
                    try {
                        if (LogChannelFileWriter.this.logFileOutputStream != null) {
                            LogChannelFileWriter.this.logFileOutputStream.close();
                            LogChannelFileWriter.this.logFileOutputStream = null;
                        }
                    }
                    catch (Exception e) {
                        LogChannelFileWriter.this.exception = new KettleException("There was an error closing log file file '" + LogChannelFileWriter.this.logFile + "'", (Throwable)e);
                    }
                }
            }
        });
        thread.start();
    }

    public synchronized void flush() {
        try {
            int last = KettleLogStore.getLastBufferLineNr();
            StringBuffer buffer = KettleLogStore.getAppender().getBuffer(this.logChannelId, false, this.lastBufferLineNr, last);
            this.logFileOutputStream.write(buffer.toString().getBytes());
            this.lastBufferLineNr = last;
            this.logFileOutputStream.flush();
        }
        catch (Exception e) {
            this.exception = new KettleException("There was an error logging to file '" + this.logFile + "'", (Throwable)e);
        }
    }

    public void stopLogging() {
        this.flush();
        this.active.set(false);
    }

    public KettleException getException() {
        return this.exception;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    public FileObject getLogFile() {
        return this.logFile;
    }

    public void setLogFile(FileObject logFile) {
        this.logFile = logFile;
    }

    public boolean isAppending() {
        return this.appending;
    }

    public void setAppending(boolean appending) {
        this.appending = appending;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }
}

