/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.autodoc;

import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObjectType;

public class ReportSubjectLocation {
    private String filename;
    private RepositoryDirectoryInterface directory;
    private String name;
    private RepositoryObjectType objectType;

    public ReportSubjectLocation(String filename, RepositoryDirectoryInterface directory, String name, RepositoryObjectType objectType) {
        this.filename = filename;
        this.directory = directory;
        this.name = name;
        this.objectType = objectType;
    }

    public String toString() {
        if (Utils.isEmpty((CharSequence)this.filename)) {
            String dir = this.directory.toString();
            if (dir.endsWith("/")) {
                return dir + this.name + " (" + this.objectType.getTypeDescription() + ")";
            }
            return dir + "/" + this.name + " (" + this.objectType.getTypeDescription() + ")";
        }
        return this.filename;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReportSubjectLocation)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.toString().equals(((ReportSubjectLocation)object).toString());
    }

    public boolean isTransformation() {
        return this.objectType.equals((Object)RepositoryObjectType.TRANSFORMATION);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public RepositoryDirectoryInterface getDirectory() {
        return this.directory;
    }

    public void setDirectory(RepositoryDirectoryInterface directory) {
        this.directory = directory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RepositoryObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(RepositoryObjectType objectType) {
        this.objectType = objectType;
    }
}

