/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.PriorityQueue;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;
import org.pentaho.di.trans.steps.databaselookup.readallcache.EqIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.GtIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.Index;
import org.pentaho.di.trans.steps.databaselookup.readallcache.IsNullIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.LtIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.SearchingContext;

public class ReadAllCache
implements DatabaseLookupData.Cache {
    private final DatabaseLookupData stepData;
    private final Object[][] keys;
    private final RowMetaInterface keysMeta;
    private final Object[][] data;
    private final Index[] indexes;
    private final int[][] otherConditions;

    ReadAllCache(DatabaseLookupData stepData, Object[][] keys, RowMetaInterface keysMeta, Object[][] data) {
        this.stepData = stepData;
        this.keys = keys;
        this.keysMeta = keysMeta;
        this.data = data;
        Object[] pair = ReadAllCache.createIndexes(stepData, keysMeta, keys);
        this.indexes = (Index[])pair[0];
        this.otherConditions = (int[][])pair[1];
    }

    private static Object[] createIndexes(DatabaseLookupData stepData, RowMetaInterface keysMeta, Object[][] keys) {
        int rowsAmount = keys.length;
        int[] conditions = stepData.conditions;
        PriorityQueue<Index> indexes = new PriorityQueue<Index>(conditions.length, Index.restrictionComparator());
        ArrayList<int[]> otherConditions = new ArrayList<int[]>();
        int len = conditions.length;
        for (int i = 0; i < len; ++i) {
            int condition = conditions[i];
            Index index = null;
            switch (condition) {
                case 0: {
                    index = new EqIndex(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 1: {
                    index = EqIndex.nonEqualityIndex(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 2: {
                    index = new LtIndex(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 3: {
                    index = GtIndex.lessOrEqualCache(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 4: {
                    index = new GtIndex(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 5: {
                    index = LtIndex.greaterOrEqualCache(i, keysMeta.getValueMeta(i), rowsAmount);
                    break;
                }
                case 8: {
                    index = new IsNullIndex(i, keysMeta.getValueMeta(i), rowsAmount, true);
                    break;
                }
                case 9: {
                    index = new IsNullIndex(i, keysMeta.getValueMeta(i), rowsAmount, false);
                }
            }
            if (index == null) {
                otherConditions.add(new int[]{i, condition});
                continue;
            }
            index.performIndexingOf(keys);
            indexes.add(index);
        }
        return new Object[]{indexes.toArray(new Index[indexes.size()]), otherConditions.toArray((T[])new int[otherConditions.size()][])};
    }

    @Override
    public Object[] getRowFromCache(RowMetaInterface lookupMeta, Object[] lookupRow) throws KettleException {
        if (this.stepData.hasDBCondition) {
            return null;
        }
        SearchingContext context = new SearchingContext();
        context.init(this.keys.length);
        for (Index index : this.indexes) {
            int column = index.getColumn();
            Object lookupValue = column < lookupRow.length ? lookupRow[column] : null;
            index.applyRestrictionsTo(context, lookupMeta.getValueMeta(column), lookupValue);
            if (!context.isEmpty()) continue;
            return null;
        }
        BitSet candidates = context.getCandidates();
        int candidate = candidates.nextSetBit(0);
        while (candidate != -1) {
            Object[] dataKeys = this.keys[candidate];
            boolean matches = true;
            int lookupShift = 0;
            int len = this.otherConditions.length;
            for (int i = 0; i < len && matches; ++i) {
                int[] columnConditionPair = this.otherConditions[i];
                int column = columnConditionPair[0];
                Object keyData = dataKeys[column];
                ValueMetaInterface keyMeta = this.keysMeta.getValueMeta(column);
                int lookupIndex = column + lookupShift;
                Object cmpData = lookupRow[lookupIndex];
                ValueMetaInterface cmpMeta = lookupMeta.getValueMeta(lookupIndex);
                int condition = columnConditionPair[1];
                if (condition == 7) {
                    Object cmpData2;
                    ValueMetaInterface cmpMeta2;
                    boolean bl = matches = keyMeta.compare(keyData, cmpMeta, cmpData) >= 0;
                    if (!matches) continue;
                    ++lookupShift;
                    matches = keyMeta.compare(keyData, cmpMeta2 = lookupMeta.getValueMeta(++lookupIndex), cmpData2 = lookupRow[lookupIndex]) <= 0;
                    continue;
                }
                matches = false;
                this.stepData.hasDBCondition = true;
            }
            if (matches) {
                return this.data[candidate];
            }
            candidate = candidates.nextSetBit(candidate + 1);
        }
        return null;
    }

    @Override
    public void storeRowInCache(DatabaseLookupMeta meta, RowMetaInterface lookupMeta, Object[] lookupRow, Object[] add) {
        throw new UnsupportedOperationException("This cache is read-only");
    }

    public static class Builder {
        private final DatabaseLookupData stepData;
        private final Object[][] keys;
        private final Object[][] data;
        private RowMetaInterface keysMeta;
        private int current;

        public Builder(DatabaseLookupData stepData, int amount) {
            this.stepData = stepData;
            this.keys = new Object[amount][];
            this.data = new Object[amount][];
        }

        public void setKeysMeta(RowMetaInterface keysMeta) {
            this.keysMeta = keysMeta;
        }

        public void add(Object[] keys, Object[] data) {
            this.keys[this.current] = keys;
            this.data[this.current] = data;
            ++this.current;
        }

        public ReadAllCache build() {
            return new ReadAllCache(this.stepData, this.keys, this.keysMeta, this.data);
        }
    }
}

