/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.playlist.FilePlayListAll;
import org.pentaho.di.core.playlist.FilePlayListReplay;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.CompositeFileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandlerContentLineNumber;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandlerMissingFiles;
import org.pentaho.di.trans.steps.excelinput.ExcelInputData;
import org.pentaho.di.trans.steps.excelinput.ExcelInputField;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;
import org.pentaho.di.trans.steps.excelinput.ExcelInputRow;
import org.pentaho.di.trans.steps.excelinput.KettleCellValueException;
import org.pentaho.di.trans.steps.excelinput.WorkbookFactory;

public class ExcelInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ExcelInputMeta.class;
    private ExcelInputMeta meta;
    private ExcelInputData data;

    public ExcelInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] fillRow(int startcolumn, ExcelInputRow excelInputRow) throws KettleException {
        Object[] r = new Object[this.data.outputRowMeta.size()];
        boolean errorHandled = false;
        KCell cell = null;
        for (int i = startcolumn; i < excelInputRow.cells.length && i - startcolumn < this.meta.getField().length; ++i) {
            ValueMetaInterface sourceMeta;
            ValueMetaInterface targetMeta;
            int rowcolumn;
            block45: {
                cell = excelInputRow.cells[i];
                rowcolumn = i - startcolumn;
                if (cell == null) {
                    r[rowcolumn] = null;
                    continue;
                }
                targetMeta = this.data.outputRowMeta.getValueMeta(rowcolumn);
                sourceMeta = null;
                try {
                    this.checkType(cell, targetMeta);
                }
                catch (KettleException ex2) {
                    if (!this.meta.isErrorIgnored()) {
                        KettleCellValueException ex2 = new KettleCellValueException(ex2, this.data.sheetnr, this.data.rownr, i, "");
                        throw ex2;
                    }
                    if (this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"ExcelInput.Log.WarningProcessingExcelFile", (String[])new String[]{"" + targetMeta, "" + this.data.filename, ex2.getMessage()}));
                    }
                    if (!errorHandled) {
                        this.data.errorHandler.handleLineError(excelInputRow.rownr, excelInputRow.sheetName);
                        errorHandled = true;
                    }
                    if (!this.meta.isErrorLineSkipped()) break block45;
                    return null;
                }
            }
            KCellType cellType = cell.getType();
            if (KCellType.BOOLEAN == cellType || KCellType.BOOLEAN_FORMULA == cellType) {
                r[rowcolumn] = cell.getValue();
                sourceMeta = this.data.valueMetaBoolean;
            } else if (KCellType.DATE.equals((Object)cellType) || KCellType.DATE_FORMULA.equals((Object)cellType)) {
                Date date = (Date)cell.getValue();
                long time = date.getTime();
                int offset = TimeZone.getDefault().getOffset(time);
                r[rowcolumn] = new Date(time - (long)offset);
                sourceMeta = this.data.valueMetaDate;
            } else if (KCellType.LABEL == cellType || KCellType.STRING_FORMULA == cellType) {
                String string = (String)cell.getValue();
                switch (this.meta.getField()[rowcolumn].getTrimType()) {
                    case 1: {
                        string = Const.ltrim((String)string);
                        break;
                    }
                    case 2: {
                        string = Const.rtrim((String)string);
                        break;
                    }
                    case 3: {
                        string = Const.trim((String)string);
                        break;
                    }
                }
                r[rowcolumn] = string;
                sourceMeta = this.data.valueMetaString;
            } else if (KCellType.NUMBER == cellType || KCellType.NUMBER_FORMULA == cellType) {
                r[rowcolumn] = cell.getValue();
                sourceMeta = this.data.valueMetaNumber;
            } else {
                if (this.log.isDetailed()) {
                    KCellType ct = cell.getType();
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.UnknownType", (String[])new String[]{ct != null ? ct.toString() : "null", cell.getContents()}));
                }
                r[rowcolumn] = null;
            }
            ExcelInputField field = this.meta.getField()[rowcolumn];
            try {
                if (sourceMeta == null || sourceMeta.getType() == targetMeta.getType() || r[rowcolumn] == null) continue;
                ValueMetaInterface sourceMetaCopy = sourceMeta.clone();
                sourceMetaCopy.setConversionMask(field.getFormat());
                sourceMetaCopy.setGroupingSymbol(field.getGroupSymbol());
                sourceMetaCopy.setDecimalSymbol(field.getDecimalSymbol());
                sourceMetaCopy.setCurrencySymbol(field.getCurrencySymbol());
                block7 : switch (targetMeta.getType()) {
                    case 1: 
                    case 5: {
                        switch (field.getType()) {
                            case 3: {
                                ValueMetaNumber valueMetaNumber = new ValueMetaNumber("num");
                                valueMetaNumber.setConversionMask("#");
                                Object string = sourceMetaCopy.convertData((ValueMetaInterface)valueMetaNumber, r[rowcolumn]);
                                r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, string);
                                break block7;
                            }
                        }
                        r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, r[rowcolumn]);
                        break;
                    }
                    default: {
                        r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, r[rowcolumn]);
                    }
                }
                continue;
            }
            catch (KettleException ex3) {
                if (!this.meta.isErrorIgnored()) {
                    KettleCellValueException ex3 = new KettleCellValueException(ex3, this.data.sheetnr, cell.getRow(), i, field.getName());
                    throw ex3;
                }
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExcelInput.Log.WarningProcessingExcelFile", (String[])new String[]{"" + targetMeta, "" + this.data.filename, ex3.toString()}));
                }
                if (!errorHandled) {
                    this.data.errorHandler.handleLineError(excelInputRow.rownr, excelInputRow.sheetName);
                    errorHandled = true;
                }
                if (this.meta.isErrorLineSkipped()) {
                    return null;
                }
                r[rowcolumn] = null;
            }
        }
        int rowIndex = this.meta.getField().length;
        if (!Utils.isEmpty((CharSequence)this.meta.getFileField())) {
            r[rowIndex] = this.data.filename;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getSheetField())) {
            r[rowIndex] = excelInputRow.sheetName;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getSheetRowNumberField())) {
            r[rowIndex] = new Long(this.data.rownr);
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getRowNumberField())) {
            r[rowIndex] = new Long(this.getLinesWritten() + 1L);
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getShortFileNameField())) {
            r[rowIndex] = this.data.shortFilename;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getExtensionField())) {
            r[rowIndex] = this.data.extension;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getPathField())) {
            r[rowIndex] = this.data.path;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getSizeField())) {
            r[rowIndex] = new Long(this.data.size);
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.isHiddenField())) {
            r[rowIndex] = new Boolean(this.data.hidden);
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getLastModificationDateField())) {
            r[rowIndex] = this.data.lastModificationDateTime;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getUriField())) {
            r[rowIndex] = this.data.uriName;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)this.meta.getRootUriField())) {
            r[rowIndex] = this.data.rootUriName;
            ++rowIndex;
        }
        return r;
    }

    private void checkType(KCell cell, ValueMetaInterface v) throws KettleException {
        if (!this.meta.isStrictTypes()) {
            return;
        }
        switch (cell.getType()) {
            case BOOLEAN: {
                if (v.getType() == 2 || v.getType() == 0 || v.getType() == 4) break;
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.InvalidTypeBoolean", (String[])new String[]{v.getTypeDesc()}));
            }
            case DATE: {
                if (v.getType() == 2 || v.getType() == 0 || v.getType() == 3) break;
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.InvalidTypeDate", (String[])new String[]{cell.getContents(), v.getTypeDesc()}));
            }
            case LABEL: {
                if (v.getType() != 4 && v.getType() != 3 && v.getType() != 5 && v.getType() != 1) break;
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.InvalidTypeLabel", (String[])new String[]{cell.getContents(), v.getTypeDesc()}));
            }
            case EMPTY: {
                break;
            }
            case NUMBER: {
                if (v.getType() == 2 || v.getType() == 0 || v.getType() == 5 || v.getType() == 6 || v.getType() == 1) break;
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.InvalidTypeNumber", (String[])new String[]{cell.getContents(), v.getTypeDesc()}));
            }
            default: {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.UnsupportedType", (String[])new String[]{cell.getType().getDescription(), cell.getContents()}));
            }
        }
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ExcelInputMeta)smi;
        this.data = (ExcelInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.meta.isAcceptingFilenames()) {
                this.data.files.getFiles().clear();
                int idx = -1;
                RowSet rowSet = this.findInputRowSet(this.meta.getAcceptingStepName());
                Object[] fileRow = this.getRowFrom(rowSet);
                while (fileRow != null) {
                    if (idx < 0 && (idx = rowSet.getRowMeta().indexOfValue(this.meta.getAcceptingField())) < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"ExcelInput.Error.FilenameFieldNotFound", (String[])new String[]{"" + this.meta.getAcceptingField()}));
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String fileValue = rowSet.getRowMeta().getString(fileRow, idx);
                    try {
                        this.data.files.addFile(KettleVFS.getFileObject((String)fileValue, (VariableSpace)this.getTransMeta()));
                    }
                    catch (KettleFileException e) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.CanNotCreateFileObject", (String[])new String[]{fileValue}), (Throwable)e);
                    }
                    fileRow = this.getRowFrom(rowSet);
                }
            }
            this.handleMissingFiles();
        }
        if (this.data.filenr >= this.data.files.nrOfFiles()) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.NoMoreFiles", (String[])new String[]{"" + this.data.filenr}));
            }
            this.setOutputDone();
            return false;
        }
        if (this.meta.getRowLimit() > 0L && (long)this.data.rownr > this.meta.getRowLimit() || this.meta.readAllSheets() && this.meta.getRowLimit() > 0L && this.data.defaultStartRow == 0 && (long)this.data.rownr > this.meta.getRowLimit() - 1L || !this.meta.readAllSheets() && this.meta.getRowLimit() > 0L && this.data.startRow[this.data.sheetnr] == 0 && (long)this.data.rownr > this.meta.getRowLimit() - 1L) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.RowLimitReached", (String[])new String[]{"" + this.meta.getRowLimit()}));
            }
            this.setOutputDone();
            return false;
        }
        Object[] r = this.getRowFromWorkbooks();
        if (r != null) {
            this.incrementLinesInput();
            if (this.data.previousRow != null) {
                for (int i = 0; i < this.meta.getField().length; ++i) {
                    Object valueData;
                    ValueMetaInterface valueMeta = this.data.outputRowMeta.getValueMeta(i);
                    if (!valueMeta.isNull(valueData = r[i]) || !this.meta.getField()[i].isRepeated()) continue;
                    r[i] = this.data.previousRow[i];
                }
            }
            this.data.previousRow = this.data.outputRowMeta.cloneRow(r);
            this.putRow(this.data.outputRowMeta, r);
            return true;
        }
        return true;
    }

    private void handleMissingFiles() throws KettleException {
        List nonAccessibleFiles;
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ExcelInput.Log.RequiredFilesTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInput.Warning.MissingFiles", (String[])new String[]{message}));
            }
            if (this.meta.isErrorIgnored()) {
                for (FileObject fileObject : nonExistantFiles) {
                    this.data.errorHandler.handleNonExistantFile(fileObject);
                }
            } else {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.MissingRequiredFiles", (String[])new String[]{message}));
            }
        }
        if ((nonAccessibleFiles = this.data.files.getNonAccessibleFiles()).size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ExcelInput.Log.RequiredFilesTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInput.Log.RequiredFilesMsgNotAccessible", (String[])new String[]{message}));
            }
            if (this.meta.isErrorIgnored()) {
                for (FileObject fileObject : nonAccessibleFiles) {
                    this.data.errorHandler.handleNonAccessibleFile(fileObject);
                }
            } else {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.RequiredFilesNotAccessible", (String[])new String[]{message}));
            }
        }
    }

    public Object[] getRowFromWorkbooks() {
        Object[] retval = null;
        try {
            String sheetName;
            KSheet sheet;
            if (this.data.workbook == null) {
                this.data.file = this.data.files.getFile(this.data.filenr);
                this.data.filename = KettleVFS.getFilename((FileObject)this.data.file);
                if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                    this.data.shortFilename = this.data.file.getName().getBaseName();
                }
                if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                    this.data.path = KettleVFS.getFilename((FileObject)this.data.file.getParent());
                }
                if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                    this.data.hidden = this.data.file.isHidden();
                }
                if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                    this.data.extension = this.data.file.getName().getExtension();
                }
                if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                    this.data.lastModificationDateTime = new Date(this.data.file.getContent().getLastModifiedTime());
                }
                if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                    this.data.uriName = this.data.file.getName().getURI();
                }
                if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                    this.data.rootUriName = this.data.file.getName().getRootURI();
                }
                if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                    this.data.size = new Long(this.data.file.getContent().getSize());
                }
                if (this.meta.isAddResultFile()) {
                    ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.toString());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"ExcelInput.Log.FileReadByStep", (String[])new String[0]));
                    this.addResultFile(resultFile);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.OpeningFile", (String[])new String[]{"" + this.data.filenr + " : " + this.data.filename}));
                }
                this.data.workbook = WorkbookFactory.getWorkbook(this.meta.getSpreadSheetType(), this.data.filename, this.meta.getEncoding());
                this.data.errorHandler.handleFile(this.data.file);
                this.data.sheetnr = 0;
                if (this.meta.readAllSheets()) {
                    this.data.sheetNames = this.data.workbook.getSheetNames();
                    this.data.startColumn = new int[this.data.sheetNames.length];
                    this.data.startRow = new int[this.data.sheetNames.length];
                    for (int i = 0; i < this.data.sheetNames.length; ++i) {
                        this.data.startColumn[i] = this.data.defaultStartColumn;
                        this.data.startRow[i] = this.data.defaultStartRow;
                    }
                }
            }
            boolean nextsheet = false;
            if (this.log.isDebug()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.GetSheet", (String[])new String[]{"" + this.data.filenr + "." + this.data.sheetnr}));
            }
            if ((sheet = this.data.workbook.getSheet(sheetName = this.data.sheetNames[this.data.sheetnr])) != null) {
                if (this.data.rownr < 0) {
                    this.data.rownr = this.data.startRow[this.data.sheetnr];
                    if (this.meta.startsWithHeader()) {
                        ++this.data.rownr;
                    }
                }
                this.data.colnr = this.data.startColumn[this.data.sheetnr];
                try {
                    KCell[] line = sheet.getRow(this.data.rownr);
                    int lineNr = ++this.data.rownr;
                    if (!this.data.filePlayList.isProcessingNeeded(this.data.file, lineNr, sheetName)) {
                        retval = null;
                    } else {
                        boolean isEmpty;
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"ExcelInput.Log.GetLine", (String[])new String[]{"" + lineNr, this.data.filenr + "." + this.data.sheetnr}));
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"ExcelInput.Log.ReadLineWith", (String[])new String[]{"" + line.length}));
                        }
                        ExcelInputRow excelInputRow = new ExcelInputRow(sheet.getName(), lineNr, line);
                        Object[] r = this.fillRow(this.data.colnr, excelInputRow);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"ExcelInput.Log.ConvertedLinToRow", (String[])new String[]{"" + lineNr, this.data.outputRowMeta.getString(r)}));
                        }
                        if (!(isEmpty = this.isLineEmpty(line)) || !this.meta.ignoreEmptyRows()) {
                            retval = r;
                        } else if (this.data.rownr > sheet.getRows()) {
                            nextsheet = true;
                        }
                        if (isEmpty && this.meta.stopOnEmpty()) {
                            nextsheet = true;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"ExcelInput.Log.OutOfIndex", (String[])new String[0]));
                    }
                    nextsheet = true;
                }
            } else {
                nextsheet = true;
            }
            if (nextsheet) {
                ++this.data.sheetnr;
                this.data.rownr = -1;
                this.data.previousRow = null;
                if (this.data.sheetnr >= this.data.sheetNames.length) {
                    this.jumpToNextFile();
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ExcelInput.Error.ProcessRowFromExcel", (String[])new String[]{this.data.filename + "", e.toString()}), e);
            this.setErrors(1L);
            this.stopAll();
            return null;
        }
        return retval;
    }

    private boolean isLineEmpty(KCell[] line) {
        if (line.length == 0) {
            return true;
        }
        boolean isEmpty = true;
        for (int i = 0; i < line.length && isEmpty; ++i) {
            if (line[i] == null || Utils.isEmpty((CharSequence)line[i].getContents())) continue;
            isEmpty = false;
        }
        return isEmpty;
    }

    private void jumpToNextFile() throws KettleException {
        this.data.sheetnr = 0;
        this.data.rownr = -1;
        this.data.previousRow = null;
        this.data.workbook.close();
        this.data.workbook = null;
        this.data.errorHandler.close();
        ++this.data.filenr;
    }

    private void initErrorHandling() {
        ArrayList<FileErrorHandler> errorHandlers = new ArrayList<FileErrorHandler>(2);
        if (this.meta.getLineNumberFilesDestinationDirectory() != null) {
            errorHandlers.add(new FileErrorHandlerContentLineNumber(this.getTrans().getCurrentDate(), this.environmentSubstitute(this.meta.getLineNumberFilesDestinationDirectory()), this.meta.getLineNumberFilesExtension(), "Latin1", this));
        }
        if (this.meta.getErrorFilesDestinationDirectory() != null) {
            errorHandlers.add(new FileErrorHandlerMissingFiles(this.getTrans().getCurrentDate(), this.environmentSubstitute(this.meta.getErrorFilesDestinationDirectory()), this.meta.getErrorFilesExtension(), "Latin1", this));
        }
        this.data.errorHandler = new CompositeFileErrorHandler(errorHandlers);
    }

    private void initReplayFactory() {
        Date replayDate = this.getTrans().getReplayDate();
        this.data.filePlayList = replayDate == null ? FilePlayListAll.INSTANCE : new FilePlayListReplay(replayDate, this.environmentSubstitute(this.meta.getLineNumberFilesDestinationDirectory()), this.meta.getLineNumberFilesExtension(), this.environmentSubstitute(this.meta.getErrorFilesDestinationDirectory()), this.meta.getErrorFilesExtension(), "Latin1");
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelInputMeta)smi;
        this.data = (ExcelInputData)sdi;
        if (super.init(smi, sdi)) {
            this.initErrorHandling();
            this.initReplayFactory();
            this.data.files = this.meta.getFileList(this);
            if (this.data.files.nrOfFiles() == 0 && this.data.files.nrOfMissingFiles() > 0 && !this.meta.isAcceptingFilenames()) {
                this.logError(BaseMessages.getString(PKG, (String)"ExcelInput.Error.NoFileSpecified", (String[])new String[0]));
                return false;
            }
            if (this.meta.getEmptyFields().size() > 0) {
                this.data.maxfilelength = -1;
                for (FileObject file : this.data.files.getFiles()) {
                    String name = KettleVFS.getFilename((FileObject)file);
                    if (name.length() <= this.data.maxfilelength) continue;
                    this.data.maxfilelength = name.length();
                }
                this.data.maxsheetlength = -1;
                if (!this.meta.readAllSheets()) {
                    this.data.sheetNames = new String[this.meta.getSheetName().length];
                    this.data.startColumn = new int[this.meta.getSheetName().length];
                    this.data.startRow = new int[this.meta.getSheetName().length];
                    for (int i = 0; i < this.meta.getSheetName().length; ++i) {
                        this.data.sheetNames[i] = this.meta.getSheetName()[i];
                        this.data.startColumn[i] = this.meta.getStartColumn()[i];
                        this.data.startRow[i] = this.meta.getStartRow()[i];
                        if (this.meta.getSheetName()[i].length() <= this.data.maxsheetlength) continue;
                        this.data.maxsheetlength = this.meta.getSheetName()[i].length();
                    }
                } else {
                    this.data.defaultStartRow = this.meta.getStartRow().length == 1 ? this.meta.getStartRow()[0] : 0;
                    this.data.defaultStartColumn = this.meta.getStartColumn().length == 1 ? this.meta.getStartColumn()[0] : 0;
                }
                return true;
            }
            this.logError(BaseMessages.getString(PKG, (String)"ExcelInput.Error.NotInputFieldsDefined", (String[])new String[0]));
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block6: {
            this.meta = (ExcelInputMeta)smi;
            this.data = (ExcelInputData)sdi;
            if (this.data.workbook != null) {
                this.data.workbook.close();
            }
            if (this.data.file != null) {
                try {
                    this.data.file.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.data.errorHandler.close();
            }
            catch (KettleException e) {
                if (!this.log.isDebug()) break block6;
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelInput.Error.CouldNotCloseErrorHandler", (String[])new String[]{e.toString()}));
                this.logDebug(Const.getStackTracker((Throwable)e));
            }
        }
        super.dispose(smi, sdi);
    }
}

