/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fixedinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fixedinput.FixedFileInputField;
import org.pentaho.di.trans.steps.fixedinput.FixedInput;
import org.pentaho.di.trans.steps.fixedinput.FixedInputData;
import org.pentaho.di.trans.steps.fixedinput.FixedInputMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class FixedInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = FixedInputMeta.class;
    public static final int FILE_TYPE_NONE = 0;
    public static final int FILE_TYPE_UNIX = 1;
    public static final int FILE_TYPE_DOS = 2;
    public static final String[] fileTypeCode = new String[]{"NONE", "UNIX", "DOS"};
    public static final String[] fileTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"FixedFileInputMeta.FileType.None.Desc", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FixedFileInputMeta.FileType.Unix.Desc", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FixedFileInputMeta.FileType.Dos.Desc", (String[])new String[0])};
    private String filename;
    private boolean headerPresent;
    private String lineWidth;
    private String bufferSize;
    private boolean lazyConversionActive;
    private boolean lineFeedPresent;
    private boolean runningInParallel;
    private int fileType;
    private boolean isaddresult;
    private String encoding;
    private FixedFileInputField[] fieldDefinition;

    public FixedInputMeta() {
        this.allocate(0);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.isaddresult = false;
        this.lineWidth = "80";
        this.headerPresent = true;
        this.lazyConversionActive = true;
        this.bufferSize = "50000";
        this.lineFeedPresent = true;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.lineWidth = XMLHandler.getTagValue((Node)stepnode, (String)"line_width");
            this.bufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"buffer_size");
            this.headerPresent = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.lineFeedPresent = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"line_feed"));
            this.lazyConversionActive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"lazy_conversion"));
            this.runningInParallel = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"parallel"));
            this.fileType = FixedInputMeta.getFileType(XMLHandler.getTagValue((Node)stepnode, (String)"file_type"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.isaddresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"add_to_result_filenames"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldDefinition[i] = new FixedFileInputField(fnode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrFields) {
        this.fieldDefinition = new FixedFileInputField[nrFields];
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_width", (String)this.lineWidth));
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.headerPresent));
        retval.append("    ").append(XMLHandler.addTagValue((String)"buffer_size", (String)this.bufferSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lazy_conversion", (boolean)this.lazyConversionActive));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_feed", (boolean)this.lineFeedPresent));
        retval.append("    ").append(XMLHandler.addTagValue((String)"parallel", (boolean)this.runningInParallel));
        retval.append("    ").append(XMLHandler.addTagValue((String)"file_type", (String)this.getFileTypeCode()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.isaddresult));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldDefinition.length; ++i) {
            retval.append(this.fieldDefinition[i].getXML());
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "filename");
            this.lineWidth = rep.getStepAttributeString(id_step, "line_width");
            this.headerPresent = rep.getStepAttributeBoolean(id_step, "header");
            this.lineFeedPresent = rep.getStepAttributeBoolean(id_step, "line_feed");
            this.bufferSize = rep.getStepAttributeString(id_step, "buffer_size");
            this.lazyConversionActive = rep.getStepAttributeBoolean(id_step, "lazy_conversion");
            this.runningInParallel = rep.getStepAttributeBoolean(id_step, "parallel");
            this.fileType = FixedInputMeta.getFileType(rep.getStepAttributeString(id_step, "file_type"));
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.isaddresult = rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                FixedFileInputField field = new FixedFileInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setTrimType(ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setCurrency(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimal(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGrouping(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setWidth((int)rep.getStepAttributeInteger(id_step, i, "field_width"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                this.fieldDefinition[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "line_width", this.lineWidth);
            rep.saveStepAttribute(id_transformation, id_step, "buffer_size", this.bufferSize);
            rep.saveStepAttribute(id_transformation, id_step, "header", this.headerPresent);
            rep.saveStepAttribute(id_transformation, id_step, "lazy_conversion", this.lazyConversionActive);
            rep.saveStepAttribute(id_transformation, id_step, "line_feed", this.lineFeedPresent);
            rep.saveStepAttribute(id_transformation, id_step, "parallel", this.runningInParallel);
            rep.saveStepAttribute(id_transformation, id_step, "file_type", FixedInputMeta.getFileTypeCode(this.fileType));
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.isaddresult);
            for (int i = 0; i < this.fieldDefinition.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldDefinition[i].getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMeta.getTypeDesc((int)this.fieldDefinition[i].getType()));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldDefinition[i].getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", ValueMeta.getTrimTypeCode((int)this.fieldDefinition[i].getTrimType()));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.fieldDefinition[i].getCurrency());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.fieldDefinition[i].getDecimal());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.fieldDefinition[i].getGrouping());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_width", this.fieldDefinition[i].getWidth());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldDefinition[i].getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldDefinition[i].getPrecision());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            for (int i = 0; i < this.fieldDefinition.length; ++i) {
                FixedFileInputField field = this.fieldDefinition[i];
                ValueMetaInterface valueMeta = ValueMetaFactory.createValueMeta((String)field.getName(), (int)field.getType());
                valueMeta.setConversionMask(field.getFormat());
                valueMeta.setTrimType(field.getTrimType());
                valueMeta.setLength(field.getLength());
                valueMeta.setPrecision(field.getPrecision());
                valueMeta.setConversionMask(field.getFormat());
                valueMeta.setDecimalSymbol(field.getDecimal());
                valueMeta.setGroupingSymbol(field.getGrouping());
                valueMeta.setCurrencySymbol(field.getCurrency());
                valueMeta.setStringEncoding(space.environmentSubstitute(this.encoding));
                if (this.lazyConversionActive) {
                    valueMeta.setStorageType(1);
                }
                ValueMetaInterface storageMetadata = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)valueMeta, (int)2);
                storageMetadata.setStorageType(0);
                valueMeta.setStorageMetadata(storageMetadata);
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta(valueMeta);
            }
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FixedInputMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FixedInputMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Utils.isEmpty((CharSequence)this.filename)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FixedInputMeta.CheckResult.NoFilenameSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FixedInputMeta.CheckResult.FilenameSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new FixedInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FixedInputData();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isLazyConversionActive() {
        return this.lazyConversionActive;
    }

    public void setLazyConversionActive(boolean lazyConversionActive) {
        this.lazyConversionActive = lazyConversionActive;
    }

    public boolean isHeaderPresent() {
        return this.headerPresent;
    }

    public void setHeaderPresent(boolean headerPresent) {
        this.headerPresent = headerPresent;
    }

    public String getLineWidth() {
        return this.lineWidth;
    }

    public boolean isLineFeedPresent() {
        return this.lineFeedPresent;
    }

    public void setLineWidth(String lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setLineFeedPresent(boolean lineFeedPresent) {
        this.lineFeedPresent = lineFeedPresent;
    }

    public boolean isRunningInParallel() {
        return this.runningInParallel;
    }

    public void setRunningInParallel(boolean runningInParallel) {
        this.runningInParallel = runningInParallel;
    }

    public FixedFileInputField[] getFieldDefinition() {
        return this.fieldDefinition;
    }

    public void setFieldDefinition(FixedFileInputField[] fieldDefinition) {
        this.fieldDefinition = fieldDefinition;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            reference.getEntries().add(new ResourceEntry(transMeta.environmentSubstitute(this.filename), ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public static final String getFileTypeCode(int fileType) {
        return fileTypeCode[fileType];
    }

    public static final String getFileTypeDesc(int fileType) {
        return fileTypeDesc[fileType];
    }

    public String getFileTypeCode() {
        return FixedInputMeta.getFileTypeCode(this.fileType);
    }

    public String getFileTypeDesc() {
        return FixedInputMeta.getFileTypeDesc(this.fileType);
    }

    public static final int getFileType(String fileTypeCode) {
        int t = Const.indexOfString((String)fileTypeCode, (String[])FixedInputMeta.fileTypeCode);
        if (t >= 0) {
            return t;
        }
        t = Const.indexOfString((String)fileTypeCode, (String[])fileTypeDesc);
        if (t >= 0) {
            return t;
        }
        return 0;
    }

    public int getLineSeparatorLength() {
        if (this.isLineFeedPresent()) {
            switch (this.fileType) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return 0;
        }
        return 0;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.filename), (VariableSpace)space);
            if (fileObject.exists()) {
                this.filename = resourceNamingInterface.nameResource(fileObject, space, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new FixedInputMetaInjection(this);
    }
}

